/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;

public class PublishExternalFunction
implements Function<String, Void> {
    public Void process(String input, Context context) {
        String externalCluster = "external";
        String publishTopic = (String)context.getUserConfigValueOrDefault("external-topic", (Object)"default-external-topic");
        String output = String.format("%s!", input);
        try {
            context.newOutputMessage(externalCluster, publishTopic, Schema.STRING).value((Object)output).sendAsync();
        }
        catch (PulsarClientException e) {
            context.getLogger().error(e.toString());
        }
        return null;
    }
}

