/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.Response;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.sonatype.aether.connector.async.TransferException;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.transfer.TransferResource;
import org.sonatype.aether.util.listener.DefaultTransferResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompletionHandler
implements ProgressAsyncHandler<Response> {
    private final Logger logger;
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final AsyncHttpClient httpClient;
    private final AtomicLong byteTransfered = new AtomicLong();
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final DefaultTransferResource transferResource;
    private final TransferEvent.RequestType requestType;

    public CompletionHandler(DefaultTransferResource transferResource, AsyncHttpClient httpClient, Logger logger, TransferEvent.RequestType requestType) {
        this.httpClient = httpClient;
        this.transferResource = transferResource;
        this.logger = logger;
        this.requestType = requestType;
    }

    public AsyncHandler.STATE onHeaderWriteCompleted() {
        if (TransferEvent.RequestType.PUT.equals((Object)this.requestType)) {
            this.byteTransfered.set(0L);
            try {
                this.fireTransferStarted();
            }
            catch (TransferCancelledException e) {
                return AsyncHandler.STATE.ABORT;
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        block3: {
            try {
                this.fireTransferProgressed(content.getBodyPartBytes());
            }
            catch (TransferCancelledException e) {
                return AsyncHandler.STATE.ABORT;
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("", (Throwable)ex);
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return status.getStatusCode() == 404 ? AsyncHandler.STATE.ABORT : AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        if (!TransferEvent.RequestType.PUT.equals((Object)this.requestType) && this.status.getStatusCode() >= 200 && this.status.getStatusCode() < 300) {
            try {
                this.transferResource.setContentLength(Long.parseLong(headers.getHeaders().getFirstValue("Content-Length")));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                this.fireTransferStarted();
            }
            catch (TransferCancelledException e) {
                return AsyncHandler.STATE.ABORT;
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public final Response onCompleted() throws Exception {
        if (this.status == null) {
            throw new TransferException("Invalid AHC State. Response will possibly gets corrupted.");
        }
        return this.onCompleted(this.httpClient.getProvider().prepareResponse(this.status, this.headers, Collections.emptyList()));
    }

    public void onThrowable(Throwable t) {
        this.exception.set(t);
    }

    public Response onCompleted(Response response) throws Exception {
        if (response != null && response.hasResponseStatus() && response.getStatusCode() >= 200 && response.getStatusCode() <= 201) {
            this.fireTransferSucceeded(response);
        }
        return response;
    }

    void fireTransferProgressed(byte[] buffer) throws TransferCancelledException {
        this.fireTransferProgressed(ByteBuffer.wrap(buffer));
    }

    void fireTransferProgressed(final ByteBuffer buffer) throws TransferCancelledException {
        final long bytesTransferred = this.byteTransfered.addAndGet(buffer.remaining());
        AsyncTransferEvent transferEvent = new AsyncTransferEvent(){

            public TransferEvent.EventType getType() {
                return TransferEvent.EventType.PROGRESSED;
            }

            public long getTransferredBytes() {
                return bytesTransferred;
            }

            public ByteBuffer getDataBuffer() {
                return buffer.asReadOnlyBuffer();
            }

            public int getDataLength() {
                return buffer.remaining();
            }
        };
        for (TransferListener listener : this.listeners) {
            listener.transferProgressed((TransferEvent)transferEvent);
        }
    }

    void fireTransferSucceeded(Response response) throws IOException {
        final long bytesTransferred = this.byteTransfered.get();
        AsyncTransferEvent transferEvent = new AsyncTransferEvent(){

            public TransferEvent.EventType getType() {
                return TransferEvent.EventType.SUCCEEDED;
            }

            public long getTransferredBytes() {
                return bytesTransferred;
            }
        };
        for (TransferListener listener : this.listeners) {
            listener.transferSucceeded((TransferEvent)transferEvent);
        }
    }

    void fireTransferFailed() throws IOException {
        final long bytesTransferred = this.byteTransfered.get();
        AsyncTransferEvent transferEvent = new AsyncTransferEvent(){

            public TransferEvent.EventType getType() {
                return TransferEvent.EventType.FAILED;
            }

            public long getTransferredBytes() {
                return bytesTransferred;
            }
        };
        for (TransferListener listener : this.listeners) {
            listener.transferFailed((TransferEvent)transferEvent);
        }
    }

    void fireTransferStarted() throws TransferCancelledException {
        AsyncTransferEvent transferEvent = new AsyncTransferEvent(){

            public TransferEvent.EventType getType() {
                return TransferEvent.EventType.STARTED;
            }

            public long getTransferredBytes() {
                return 0L;
            }
        };
        for (TransferListener listener : this.listeners) {
            listener.transferStarted((TransferEvent)transferEvent);
        }
    }

    public boolean addTransferListener(TransferListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.offer(listener);
    }

    public boolean removeTransferListener(TransferListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    protected HttpResponseStatus status() {
        return this.status;
    }

    abstract class AsyncTransferEvent
    implements TransferEvent {
        AsyncTransferEvent() {
        }

        public TransferEvent.RequestType getRequestType() {
            return CompletionHandler.this.requestType;
        }

        public TransferResource getResource() {
            return CompletionHandler.this.transferResource;
        }

        public ByteBuffer getDataBuffer() {
            return null;
        }

        public int getDataLength() {
            return 0;
        }

        public Exception getException() {
            return Exception.class.isAssignableFrom(((Throwable)CompletionHandler.this.exception.get()).getClass()) ? (Exception)Exception.class.cast(CompletionHandler.this.exception.get()) : new Exception((Throwable)CompletionHandler.this.exception.get());
        }

        public String toString() {
            return this.getRequestType() + " " + this.getType() + " " + this.getResource();
        }
    }
}

