/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;

public class PulsarConnectorUtils {
    public static Schema parseSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public static boolean isPartitionedTopic(TopicName topicName, PulsarAdmin pulsarAdmin) throws PulsarAdminException {
        return pulsarAdmin.topics().getPartitionedTopicMetadata((String)topicName.toString()).partitions > 0;
    }

    public static <T> T createInstance(String userClassName, Class<T> xface, ClassLoader classLoader) {
        Class<?> theCls;
        try {
            theCls = Class.forName(userClassName, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            throw new RuntimeException("User class must be in class path", cnfe);
        }
        if (!xface.isAssignableFrom(theCls)) {
            throw new RuntimeException(userClassName + " not " + xface.getName());
        }
        Class<T> tCls = theCls.asSubclass(xface);
        try {
            Constructor<T> meth = tCls.getDeclaredConstructor(new Class[0]);
            return meth.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("User class must have a no-arg constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("User class must a public constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("User class constructor throws exception", e);
        }
    }

    public static Properties getProperties(Map<String, String> configMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public static String rewriteNamespaceDelimiterIfNeeded(String namespace, PulsarConnectorConfig config) {
        return config.getNamespaceDelimiterRewriteEnable() ? namespace.replace("/", config.getRewriteNamespaceDelimiter()) : namespace;
    }

    public static String restoreNamespaceDelimiterIfNeeded(String namespace, PulsarConnectorConfig config) {
        return config.getNamespaceDelimiterRewriteEnable() ? namespace.replace(config.getRewriteNamespaceDelimiter(), "/") : namespace;
    }
}

