/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.TypeManager;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.PulsarRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.avro.PulsarAvroRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.json.PulsarJsonRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.primitive.PulsarPrimitiveRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.protobufnative.PulsarProtobufNativeRowDecoderFactory;

public class PulsarDispatchingRowDecoderFactory {
    private static final Logger log = Logger.get(PulsarDispatchingRowDecoderFactory.class);
    private TypeManager typeManager;

    @Inject
    public PulsarDispatchingRowDecoderFactory(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public PulsarRowDecoder createRowDecoder(TopicName topicName, SchemaInfo schemaInfo, Set<DecoderColumnHandle> columns) {
        PulsarRowDecoderFactory rowDecoderFactory = this.createDecoderFactory(schemaInfo);
        return rowDecoderFactory.createRowDecoder(topicName, schemaInfo, columns);
    }

    public List<ColumnMetadata> extractColumnMetadata(TopicName topicName, SchemaInfo schemaInfo, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        PulsarRowDecoderFactory rowDecoderFactory = this.createDecoderFactory(schemaInfo);
        return rowDecoderFactory.extractColumnMetadata(topicName, schemaInfo, handleKeyValueType);
    }

    private PulsarRowDecoderFactory createDecoderFactory(SchemaInfo schemaInfo) {
        if (SchemaType.AVRO.equals((Object)schemaInfo.getType())) {
            return new PulsarAvroRowDecoderFactory(this.typeManager);
        }
        if (SchemaType.JSON.equals((Object)schemaInfo.getType())) {
            return new PulsarJsonRowDecoderFactory(this.typeManager);
        }
        if (SchemaType.PROTOBUF_NATIVE.equals((Object)schemaInfo.getType())) {
            return new PulsarProtobufNativeRowDecoderFactory(this.typeManager);
        }
        if (schemaInfo.getType().isPrimitive()) {
            return new PulsarPrimitiveRowDecoderFactory();
        }
        throw new RuntimeException(String.format("'%s' is unsupported type '%s'", schemaInfo.getName(), schemaInfo.getType()));
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }
}

