/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.primitive;

import io.netty.buffer.ByteBuf;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.FieldValueProviders;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.sql.presto.PulsarFieldValueProviders;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;

public class PulsarPrimitiveRowDecoder
implements PulsarRowDecoder {
    private final DecoderColumnHandle columnHandle;
    private AbstractSchema schema;

    public PulsarPrimitiveRowDecoder(AbstractSchema schema, DecoderColumnHandle column) {
        this.columnHandle = column;
        this.schema = schema;
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(ByteBuf byteBuf) {
        if (this.columnHandle == null) {
            return Optional.empty();
        }
        Object value = this.schema.decode(byteBuf);
        HashMap<DecoderColumnHandle, FieldValueProvider> primitiveColumn = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        if (value == null) {
            primitiveColumn.put(this.columnHandle, FieldValueProviders.nullValueProvider());
        } else {
            Type type = this.columnHandle.getType();
            if (type instanceof BooleanType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.booleanValueProvider((boolean)((Boolean)value)));
            } else if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)Long.parseLong(value.toString())));
            } else if (type instanceof DoubleType) {
                primitiveColumn.put(this.columnHandle, PulsarFieldValueProviders.doubleValueProvider(Double.parseDouble(value.toString())));
            } else if (type instanceof RealType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)Float.floatToIntBits(Float.parseFloat(value.toString()))));
            } else if (type instanceof VarbinaryType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.bytesValueProvider((byte[])((byte[])value)));
            } else if (type instanceof VarcharType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.bytesValueProvider((byte[])value.toString().getBytes()));
            } else if (type instanceof DateType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)((Date)value).getTime()));
            } else if (type instanceof TimeType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)((Time)value).getTime()));
            } else if (type instanceof TimestampType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)((Timestamp)value).getTime()));
            } else {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.bytesValueProvider((byte[])value.toString().getBytes()));
            }
        }
        return Optional.of(primitiveColumn);
    }
}

