/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class WarningCode {
    private final int code;
    private final String name;

    @JsonCreator
    public WarningCode(@JsonProperty(value="code") int code, @JsonProperty(value="name") String name) {
        if (code < 0) {
            throw new IllegalArgumentException("code is negative");
        }
        this.code = code;
        this.name = Objects.requireNonNull(name, "name is null");
    }

    @JsonProperty
    public int getCode() {
        return this.code;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + ":" + this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WarningCode that = (WarningCode)obj;
        return this.code == that.code && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name);
    }
}

