/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class InMemoryRecordSet
implements RecordSet {
    private final List<Type> types;
    private final Iterable<? extends List<?>> records;

    public InMemoryRecordSet(Collection<? extends Type> types, Iterable<? extends List<?>> records) {
        this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
        this.records = records;
    }

    @Override
    public List<Type> getColumnTypes() {
        return this.types;
    }

    @Override
    public RecordCursor cursor() {
        return new InMemoryRecordCursor(this.types, this.records.iterator());
    }

    public static Builder builder(ConnectorTableMetadata tableMetadata) {
        return InMemoryRecordSet.builder(tableMetadata.getColumns());
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ArrayList<Type> columnTypes = new ArrayList<Type>();
        for (ColumnMetadata column : columns) {
            columnTypes.add(column.getType());
        }
        return InMemoryRecordSet.builder(columnTypes);
    }

    public static Builder builder(Collection<Type> columnsTypes) {
        return new Builder(columnsTypes);
    }

    private static void checkArgument(boolean test, String message, Object ... args) {
        if (!test) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    private static void checkState(boolean test, String message) {
        if (!test) {
            throw new IllegalStateException(message);
        }
    }

    private static long sizeOf(List<?> record) {
        long completedBytes = 0L;
        for (Object value : record) {
            if (value == null) continue;
            if (value instanceof Boolean) {
                ++completedBytes;
                continue;
            }
            if (value instanceof Number) {
                completedBytes += 8L;
                continue;
            }
            if (value instanceof String) {
                completedBytes += (long)((String)value).length();
                continue;
            }
            if (value instanceof byte[]) {
                completedBytes += (long)((byte[])value).length;
                continue;
            }
            if (value instanceof Block) {
                completedBytes += ((Block)value).getSizeInBytes();
                continue;
            }
            if (value instanceof Slice) {
                completedBytes += (long)((Slice)value).length();
                continue;
            }
            throw new IllegalArgumentException("Unknown type: " + value.getClass());
        }
        return completedBytes;
    }

    public static class Builder {
        private final List<Type> types;
        private final List<List<Object>> records = new ArrayList<List<Object>>();

        private Builder(Collection<Type> types) {
            Objects.requireNonNull(types, "types is null");
            this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
            InMemoryRecordSet.checkArgument(!this.types.isEmpty(), "types is empty", new Object[0]);
        }

        public Builder addRow(Object ... values) {
            Objects.requireNonNull(values, "values is null");
            InMemoryRecordSet.checkArgument(values.length == this.types.size(), "Expected %s values in row, but got %s values", new Object[]{this.types.size(), values.length});
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value == null) continue;
                Type type = this.types.get(i);
                if (BooleanType.BOOLEAN.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Boolean, "Expected value %s to be an instance of Boolean, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (IntegerType.INTEGER.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Integer, "Expected value %s to be an instance of Integer, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (BigintType.BIGINT.equals(type) || DateType.DATE.equals(type) || TimestampType.TIMESTAMP.equals(type) || TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Integer || value instanceof Long, "Expected value %d to be an instance of Integer or Long, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (DoubleType.DOUBLE.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Double, "Expected value %s to be an instance of Double, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (VarcharType.VARCHAR.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof String || value instanceof byte[], "Expected value %d to be an instance of String or byte[], but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (VarbinaryType.VARBINARY.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Slice, "Expected value %d to be an instance of Slice, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (type instanceof ArrayType) {
                    InMemoryRecordSet.checkArgument(value instanceof Block, "Expected value %d to be an instance of Block, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (type instanceof RowType) {
                    InMemoryRecordSet.checkArgument(value instanceof Block, "Expected value %d to be an instance of Block, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (Decimals.isShortDecimal(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Long, "Expected value %d to be an instance of Long, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (Decimals.isLongDecimal(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Slice, "Expected value %d to be an instance of Slice, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                throw new IllegalStateException("Unsupported column type " + this.types.get(i));
            }
            this.records.add(Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(values))));
            return this;
        }

        public InMemoryRecordSet build() {
            return new InMemoryRecordSet(this.types, this.records);
        }
    }

    private static class InMemoryRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Iterator<? extends List<?>> records;
        private List<?> record;
        private long completedBytes;

        private InMemoryRecordCursor(List<Type> types, Iterator<? extends List<?>> records) {
            this.types = types;
            this.records = records;
        }

        @Override
        public long getCompletedBytes() {
            return this.completedBytes;
        }

        @Override
        public long getReadTimeNanos() {
            return 0L;
        }

        @Override
        public Type getType(int field) {
            return this.types.get(field);
        }

        @Override
        public boolean advanceNextPosition() {
            if (!this.records.hasNext()) {
                this.record = null;
                return false;
            }
            this.record = this.records.next();
            this.completedBytes += InMemoryRecordSet.sizeOf(this.record);
            return true;
        }

        @Override
        public boolean getBoolean(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Objects.requireNonNull(this.record.get(field), "value is null");
            return (Boolean)this.record.get(field);
        }

        @Override
        public long getLong(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Objects.requireNonNull(this.record.get(field), "value is null");
            return ((Number)this.record.get(field)).longValue();
        }

        @Override
        public double getDouble(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Objects.requireNonNull(this.record.get(field), "value is null");
            return (Double)this.record.get(field);
        }

        @Override
        public Slice getSlice(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Object value = this.record.get(field);
            Objects.requireNonNull(value, "value is null");
            if (value instanceof byte[]) {
                return Slices.wrappedBuffer((byte[])((byte[])value));
            }
            if (value instanceof String) {
                return Slices.utf8Slice((String)((String)value));
            }
            if (value instanceof Slice) {
                return (Slice)value;
            }
            throw new IllegalArgumentException("Field " + field + " is not a String, but is a " + value.getClass().getName());
        }

        @Override
        public Object getObject(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Object value = this.record.get(field);
            Objects.requireNonNull(value, "value is null");
            return value;
        }

        @Override
        public boolean isNull(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            return this.record.get(field) == null;
        }

        @Override
        public void close() {
        }
    }
}

