/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.IntArrayBlockBuilder;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.TypeSignature;

public abstract class AbstractIntType
extends AbstractType
implements FixedWidthType {
    protected AbstractIntType(TypeSignature signature) {
        super(signature, Long.TYPE);
    }

    @Override
    public final int getFixedSize() {
        return 4;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getInt(position, 0);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_INT", value));
        }
        if (value < Integer.MIN_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_INT", value));
        }
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeInt(block.getInt(position, 0)).closeEntry();
        }
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int rightValue;
        int leftValue = leftBlock.getInt(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getInt(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return AbstractIntType.hash(block.getInt(position, 0));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int leftValue = leftBlock.getInt(leftPosition, 0);
        int rightValue = rightBlock.getInt(rightPosition, 0);
        return Integer.compare(leftValue, rightValue);
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new IntArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 4));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 4);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new IntArrayBlockBuilder(null, positionCount);
    }

    public static long hash(int value) {
        return Long.rotateLeft((long)value * -4417276706812531889L, 31) * -7046029288634856825L;
    }
}

