/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;

public final class LedgerMetadataUtils {
    private static final String METADATA_PROPERTY_APPLICATION = "application";
    private static final byte[] METADATA_PROPERTY_APPLICATION_PULSAR = "pulsar".getBytes(StandardCharsets.UTF_8);
    private static final String METADATA_PROPERTY_COMPONENT = "component";
    private static final byte[] METADATA_PROPERTY_COMPONENT_MANAGED_LEDGER = "managed-ledger".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA_PROPERTY_COMPONENT_COMPACTED_LEDGER = "compacted-ledger".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA_PROPERTY_COMPONENT_SCHEMA = "schema".getBytes(StandardCharsets.UTF_8);
    private static final String METADATA_PROPERTY_MANAGED_LEDGER_NAME = "pulsar/managed-ledger";
    private static final String METADATA_PROPERTY_CURSOR_NAME = "pulsar/cursor";
    private static final String METADATA_PROPERTY_COMPACTEDTOPIC = "pulsar/compactedTopic";
    private static final String METADATA_PROPERTY_COMPACTEDTO = "pulsar/compactedTo";
    private static final String METADATA_PROPERTY_SCHEMAID = "pulsar/schemaId";

    static Map<String, byte[]> buildBaseManagedLedgerMetadata(String name) {
        return ImmutableMap.of((Object)METADATA_PROPERTY_APPLICATION, (Object)METADATA_PROPERTY_APPLICATION_PULSAR, (Object)METADATA_PROPERTY_COMPONENT, (Object)METADATA_PROPERTY_COMPONENT_MANAGED_LEDGER, (Object)METADATA_PROPERTY_MANAGED_LEDGER_NAME, (Object)name.getBytes(StandardCharsets.UTF_8));
    }

    static Map<String, byte[]> buildAdditionalMetadataForCursor(String name) {
        return ImmutableMap.of((Object)METADATA_PROPERTY_CURSOR_NAME, (Object)name.getBytes(StandardCharsets.UTF_8));
    }

    public static Map<String, byte[]> buildMetadataForCompactedLedger(String compactedTopic, byte[] compactedToMessageId) {
        return ImmutableMap.of((Object)METADATA_PROPERTY_APPLICATION, (Object)METADATA_PROPERTY_APPLICATION_PULSAR, (Object)METADATA_PROPERTY_COMPONENT, (Object)METADATA_PROPERTY_COMPONENT_COMPACTED_LEDGER, (Object)METADATA_PROPERTY_COMPACTEDTOPIC, (Object)compactedTopic.getBytes(StandardCharsets.UTF_8), (Object)METADATA_PROPERTY_COMPACTEDTO, (Object)compactedToMessageId);
    }

    public static Map<String, byte[]> buildMetadataForSchema(String schemaId) {
        return ImmutableMap.of((Object)METADATA_PROPERTY_APPLICATION, (Object)METADATA_PROPERTY_APPLICATION_PULSAR, (Object)METADATA_PROPERTY_COMPONENT, (Object)METADATA_PROPERTY_COMPONENT_SCHEMA, (Object)METADATA_PROPERTY_SCHEMAID, (Object)schemaId.getBytes(StandardCharsets.UTF_8));
    }

    static Map<String, byte[]> buildMetadataForPlacementPolicyConfig(Class<? extends EnsemblePlacementPolicy> className, Map<String, Object> properties) throws EnsemblePlacementPolicyConfig.ParseEnsemblePlacementPolicyConfigException {
        EnsemblePlacementPolicyConfig config = new EnsemblePlacementPolicyConfig(className, properties);
        return ImmutableMap.of((Object)"EnsemblePlacementPolicyConfig", (Object)config.encode());
    }

    private LedgerMetadataUtils() {
    }
}

