/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.namespace.NamespaceBundleOwnershipListener;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.util.RetryUtil;
import org.apache.pulsar.common.events.ActionType;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.events.TopicPoliciesEvent;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTopicBasedTopicPoliciesService
implements TopicPoliciesService {
    private final PulsarService pulsarService;
    private volatile NamespaceEventsSystemTopicFactory namespaceEventsSystemTopicFactory;
    @VisibleForTesting
    final Map<TopicName, TopicPolicies> policiesCache = new ConcurrentHashMap<TopicName, TopicPolicies>();
    private final Map<NamespaceName, AtomicInteger> ownedBundlesCountPerNamespace = new ConcurrentHashMap<NamespaceName, AtomicInteger>();
    private final Map<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>> readerCaches = new ConcurrentHashMap<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>>();
    @VisibleForTesting
    final Map<NamespaceName, Boolean> policyCacheInitMap = new ConcurrentHashMap<NamespaceName, Boolean>();
    @VisibleForTesting
    final Map<TopicName, List<TopicPolicyListener<TopicPolicies>>> listeners = new ConcurrentHashMap<TopicName, List<TopicPolicyListener<TopicPolicies>>>();
    private static final Logger log = LoggerFactory.getLogger(SystemTopicBasedTopicPoliciesService.class);

    public SystemTopicBasedTopicPoliciesService(PulsarService pulsarService) {
        this.pulsarService = pulsarService;
    }

    @Override
    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
        return this.sendTopicPolicyEvent(topicName, ActionType.DELETE, null);
    }

    @Override
    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, TopicPolicies policies) {
        return this.sendTopicPolicyEvent(topicName, ActionType.UPDATE, policies);
    }

    private CompletableFuture<Void> sendTopicPolicyEvent(TopicName topicName, ActionType actionType, TopicPolicies policies) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            this.createSystemTopicFactoryIfNeeded();
        }
        catch (PulsarServerException e) {
            result.completeExceptionally(e);
            return result;
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
        CompletableFuture writerFuture = systemTopicClient.newWriterAsync();
        writerFuture.whenComplete((writer, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
            } else {
                PulsarEvent event = this.getPulsarEvent(topicName, actionType, policies);
                CompletableFuture<MessageId> actionFuture = ActionType.DELETE.equals((Object)actionType) ? writer.deleteAsync(event) : writer.writeAsync(event);
                actionFuture.whenComplete((messageId, e) -> {
                    if (e != null) {
                        result.completeExceptionally((Throwable)e);
                    } else if (messageId != null) {
                        result.complete(null);
                    } else {
                        result.completeExceptionally(new RuntimeException("Got message id is null."));
                    }
                    writer.closeAsync().whenComplete((v, cause) -> {
                        if (cause != null) {
                            log.error("[{}] Close writer error.", (Object)topicName, cause);
                        } else if (log.isDebugEnabled()) {
                            log.debug("[{}] Close writer success.", (Object)topicName);
                        }
                    });
                });
            }
        });
        return result;
    }

    private PulsarEvent getPulsarEvent(TopicName topicName, ActionType actionType, TopicPolicies policies) {
        return PulsarEvent.builder().actionType(actionType).eventType(EventType.TOPIC_POLICY).topicPoliciesEvent(TopicPoliciesEvent.builder().domain(topicName.getDomain().toString()).tenant(topicName.getTenant()).namespace(topicName.getNamespaceObject().getLocalName()).topic(TopicName.get((String)topicName.getPartitionedTopicName()).getLocalName()).policies(policies).build()).build();
    }

    private void notifyListener(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            TopicName topicName = TopicName.get((String)TopicName.get((String)msg.getKey()).getPartitionedTopicName());
            if (this.listeners.get(topicName) != null) {
                for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                    listener.onUpdate(null);
                }
            }
            return;
        }
        if (!EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
            return;
        }
        TopicPoliciesEvent event = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
        TopicName topicName = TopicName.get((String)event.getDomain(), (String)event.getTenant(), (String)event.getNamespace(), (String)event.getTopic());
        if (this.listeners.get(topicName) != null) {
            TopicPolicies policies = event.getPolicies();
            for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                listener.onUpdate(policies);
            }
        }
    }

    @Override
    public TopicPolicies getTopicPolicies(TopicName topicName) throws BrokerServiceException.TopicPoliciesCacheNotInitException {
        if (!this.policyCacheInitMap.containsKey(topicName.getNamespaceObject())) {
            NamespaceName namespace = topicName.getNamespaceObject();
            this.prepareInitPoliciesCache(namespace, new CompletableFuture<Void>());
        }
        if (this.policyCacheInitMap.containsKey(topicName.getNamespaceObject()) && !this.policyCacheInitMap.get(topicName.getNamespaceObject()).booleanValue()) {
            throw new BrokerServiceException.TopicPoliciesCacheNotInitException();
        }
        return this.policiesCache.get(TopicName.get((String)topicName.getPartitionedTopicName()));
    }

    @Override
    public TopicPolicies getTopicPoliciesIfExists(TopicName topicName) {
        return this.policiesCache.get(TopicName.get((String)topicName.getPartitionedTopicName()));
    }

    @Override
    public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName topicName) {
        CompletableFuture<TopicPolicies> result = new CompletableFuture<TopicPolicies>();
        try {
            this.createSystemTopicFactoryIfNeeded();
        }
        catch (PulsarServerException e) {
            result.complete(null);
            return result;
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
        systemTopicClient.newReaderAsync().thenAccept(r -> this.fetchTopicPoliciesAsyncAndCloseReader((SystemTopicClient.Reader<PulsarEvent>)r, topicName, null, result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.checkHeartbeatNamespace((ServiceUnitId)namespace) != null || NamespaceService.checkHeartbeatNamespaceV2((ServiceUnitId)namespace) != null) {
            result.complete(null);
            return result;
        }
        SystemTopicBasedTopicPoliciesService systemTopicBasedTopicPoliciesService = this;
        synchronized (systemTopicBasedTopicPoliciesService) {
            if (this.readerCaches.get(namespace) != null) {
                this.ownedBundlesCountPerNamespace.get(namespace).incrementAndGet();
                result.complete(null);
            } else {
                this.ownedBundlesCountPerNamespace.putIfAbsent(namespace, new AtomicInteger(1));
                this.prepareInitPoliciesCache(namespace, result);
            }
        }
        return result;
    }

    private void prepareInitPoliciesCache(NamespaceName namespace, CompletableFuture<Void> result) {
        if (this.policyCacheInitMap.putIfAbsent(namespace, false) == null) {
            CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerCompletableFuture = this.creatSystemTopicClientWithRetry(namespace);
            this.readerCaches.put(namespace, readerCompletableFuture);
            readerCompletableFuture.whenComplete((reader, ex) -> {
                if (ex != null) {
                    log.error("[{}] Failed to create reader on __change_events topic", (Object)namespace, ex);
                    result.completeExceptionally((Throwable)ex);
                    this.readerCaches.remove(namespace);
                    reader.closeAsync();
                } else {
                    this.initPolicesCache((SystemTopicClient.Reader<PulsarEvent>)reader, result);
                    result.thenRun(() -> this.readMorePolicies((SystemTopicClient.Reader<PulsarEvent>)reader));
                }
            });
        }
    }

    protected CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> creatSystemTopicClientWithRetry(NamespaceName namespace) {
        CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> result = new CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>();
        try {
            this.createSystemTopicFactoryIfNeeded();
        }
        catch (PulsarServerException e) {
            result.completeExceptionally(e);
            return result;
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(namespace);
        Backoff backoff = new Backoff(1L, TimeUnit.SECONDS, 3L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
        RetryUtil.retryAsynchronously(() -> {
            try {
                return systemTopicClient.newReader();
            }
            catch (PulsarClientException e) {
                throw new RuntimeException(e);
            }
        }, (Backoff)backoff, (ScheduledExecutorService)this.pulsarService.getExecutor(), result);
        return result;
    }

    @Override
    public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerCompletableFuture;
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.checkHeartbeatNamespace((ServiceUnitId)namespace) != null || NamespaceService.checkHeartbeatNamespaceV2((ServiceUnitId)namespace) != null) {
            return CompletableFuture.completedFuture(null);
        }
        AtomicInteger bundlesCount = this.ownedBundlesCountPerNamespace.get(namespace);
        if ((bundlesCount == null || bundlesCount.decrementAndGet() <= 0) && (readerCompletableFuture = this.readerCaches.remove(namespace)) != null) {
            readerCompletableFuture.thenAccept(SystemTopicClient.Reader::closeAsync);
            this.ownedBundlesCountPerNamespace.remove(namespace);
            this.policyCacheInitMap.remove(namespace);
            this.policiesCache.entrySet().removeIf(entry -> ((TopicName)entry.getKey()).getNamespaceObject().equals((Object)namespace));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void start() {
        this.pulsarService.getNamespaceService().addNamespaceBundleOwnershipListener(new NamespaceBundleOwnershipListener(){

            @Override
            public void onLoad(NamespaceBundle bundle) {
                SystemTopicBasedTopicPoliciesService.this.addOwnedNamespaceBundleAsync(bundle);
            }

            @Override
            public void unLoad(NamespaceBundle bundle) {
                SystemTopicBasedTopicPoliciesService.this.removeOwnedNamespaceBundleAsync(bundle);
            }

            @Override
            public boolean test(NamespaceBundle namespaceBundle) {
                return true;
            }
        });
    }

    private void initPolicesCache(SystemTopicClient.Reader<PulsarEvent> reader, CompletableFuture<Void> future) {
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to check the move events for the system topic", (Object)reader.getSystemTopic().getTopicName(), ex);
                future.completeExceptionally((Throwable)ex);
                this.readerCaches.remove(reader.getSystemTopic().getTopicName().getNamespaceObject());
                this.policyCacheInitMap.remove(reader.getSystemTopic().getTopicName().getNamespaceObject());
                reader.closeAsync();
                return;
            }
            if (hasMore.booleanValue()) {
                reader.readNextAsync().whenComplete((msg, e) -> {
                    if (e != null) {
                        log.error("[{}] Failed to read event from the system topic.", (Object)reader.getSystemTopic().getTopicName(), ex);
                        future.completeExceptionally((Throwable)e);
                        this.readerCaches.remove(reader.getSystemTopic().getTopicName().getNamespaceObject());
                        this.policyCacheInitMap.remove(reader.getSystemTopic().getTopicName().getNamespaceObject());
                        reader.closeAsync();
                        return;
                    }
                    this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Loop next event reading for system topic.", (Object)reader.getSystemTopic().getTopicName().getNamespaceObject());
                    }
                    this.initPolicesCache(reader, future);
                });
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Reach the end of the system topic.", (Object)reader.getSystemTopic().getTopicName());
                }
                this.policyCacheInitMap.computeIfPresent(reader.getSystemTopic().getTopicName().getNamespaceObject(), (k, v) -> true);
                this.policiesCache.forEach((topicName, topicPolicies) -> {
                    if (this.listeners.get(topicName) != null) {
                        for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                            listener.onUpdate((TopicPolicies)topicPolicies);
                        }
                    }
                });
                future.complete(null);
            }
        });
    }

    private void readMorePolicies(SystemTopicClient.Reader<PulsarEvent> reader) {
        reader.readNextAsync().whenComplete((msg, ex) -> {
            if (ex == null) {
                this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                this.notifyListener((Message<PulsarEvent>)msg);
                this.readMorePolicies(reader);
            } else if (ex instanceof PulsarClientException.AlreadyClosedException) {
                log.error("Read more topic policies exception, close the read now!", ex);
                NamespaceName namespace = reader.getSystemTopic().getTopicName().getNamespaceObject();
                this.ownedBundlesCountPerNamespace.remove(namespace);
                this.readerCaches.remove(namespace);
            } else {
                this.readMorePolicies(reader);
            }
        });
    }

    private void refreshTopicPoliciesCache(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            this.policiesCache.remove(TopicName.get((String)TopicName.get((String)msg.getKey()).getPartitionedTopicName()));
            return;
        }
        if (EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
            TopicPoliciesEvent event = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
            TopicName topicName = TopicName.get((String)event.getDomain(), (String)event.getTenant(), (String)event.getNamespace(), (String)event.getTopic());
            switch (((PulsarEvent)msg.getValue()).getActionType()) {
                case INSERT: {
                    TopicPolicies old = this.policiesCache.putIfAbsent(topicName, event.getPolicies());
                    if (old == null) break;
                    log.warn("Policy insert failed, the topic: {}' policy already exist", (Object)topicName);
                    break;
                }
                case UPDATE: {
                    this.policiesCache.put(topicName, event.getPolicies());
                    break;
                }
                case DELETE: {
                    this.policiesCache.remove(topicName);
                    try {
                        this.createSystemTopicFactoryIfNeeded();
                    }
                    catch (PulsarServerException e) {
                        log.error("Failed to create system topic factory");
                        break;
                    }
                    TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
                    systemTopicClient.newWriterAsync().thenAccept(writer -> writer.deleteAsync(this.getPulsarEvent(topicName, ActionType.DELETE, null)).whenComplete((result, e) -> writer.closeAsync().whenComplete((res, ex) -> {
                        if (ex != null) {
                            log.error("close writer failed ", ex);
                        }
                    })));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    log.warn("Unknown event action type: {}", (Object)((PulsarEvent)msg.getValue()).getActionType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSystemTopicFactoryIfNeeded() throws PulsarServerException {
        if (this.namespaceEventsSystemTopicFactory == null) {
            SystemTopicBasedTopicPoliciesService systemTopicBasedTopicPoliciesService = this;
            synchronized (systemTopicBasedTopicPoliciesService) {
                if (this.namespaceEventsSystemTopicFactory == null) {
                    try {
                        this.namespaceEventsSystemTopicFactory = new NamespaceEventsSystemTopicFactory(this.pulsarService.getClient());
                    }
                    catch (PulsarServerException e) {
                        log.error("Create namespace event system topic factory error.", (Throwable)e);
                        throw e;
                    }
                }
            }
        }
    }

    private void fetchTopicPoliciesAsyncAndCloseReader(SystemTopicClient.Reader<PulsarEvent> reader, TopicName topicName, TopicPolicies policies, CompletableFuture<TopicPolicies> future) {
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            }
            if (hasMore.booleanValue()) {
                reader.readNextAsync().whenComplete((msg, e) -> {
                    if (e != null) {
                        future.completeExceptionally((Throwable)e);
                    }
                    if (msg.getValue() != null && EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
                        TopicPoliciesEvent topicPoliciesEvent = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
                        if (topicName.equals((Object)TopicName.get((String)topicPoliciesEvent.getDomain(), (String)topicPoliciesEvent.getTenant(), (String)topicPoliciesEvent.getNamespace(), (String)topicPoliciesEvent.getTopic()))) {
                            this.fetchTopicPoliciesAsyncAndCloseReader(reader, topicName, topicPoliciesEvent.getPolicies(), future);
                        } else {
                            this.fetchTopicPoliciesAsyncAndCloseReader(reader, topicName, policies, future);
                        }
                    }
                });
            } else {
                future.complete(policies);
                reader.closeAsync().whenComplete((v, e) -> {
                    if (e != null) {
                        log.error("[{}] Close reader error.", (Object)topicName, e);
                    }
                });
            }
        });
    }

    @VisibleForTesting
    long getPoliciesCacheSize() {
        return this.policiesCache.size();
    }

    @VisibleForTesting
    long getReaderCacheCount() {
        return this.readerCaches.size();
    }

    @VisibleForTesting
    boolean checkReaderIsCached(NamespaceName namespaceName) {
        return this.readerCaches.get(namespaceName) != null;
    }

    @VisibleForTesting
    public Boolean getPoliciesCacheInit(NamespaceName namespaceName) {
        return this.policyCacheInitMap.get(namespaceName);
    }

    @Override
    public void registerListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        this.listeners.compute(topicName, (k, topicListeners) -> {
            if (topicListeners == null) {
                topicListeners = Lists.newCopyOnWriteArrayList();
            }
            topicListeners.add(listener);
            return topicListeners;
        });
    }

    @Override
    public void unregisterListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        this.listeners.compute(topicName, (k, topicListeners) -> {
            if (topicListeners != null) {
                topicListeners.remove(listener);
                if (topicListeners.isEmpty()) {
                    topicListeners = null;
                }
            }
            return topicListeners;
        });
    }

    @Override
    public void clean(TopicName topicName) {
        TopicName realTopicName = topicName;
        if (topicName.isPartitioned()) {
            realTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
        }
        this.listeners.remove(realTopicName);
    }

    @VisibleForTesting
    protected Map<TopicName, TopicPolicies> getPoliciesCache() {
        return this.policiesCache;
    }

    @VisibleForTesting
    protected Map<TopicName, List<TopicPolicyListener<TopicPolicies>>> getListeners() {
        return this.listeners;
    }
}

