/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import com.google.common.collect.EvictingQueue;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.util.RateLimiter;
import org.apache.pulsar.functions.instance.stats.ComponentStatsManager;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.proto.InstanceCommunication;

public class SinkStatsManager
extends ComponentStatsManager {
    public static final String PULSAR_SINK_METRICS_PREFIX = "pulsar_sink_";
    public static final String SYSTEM_EXCEPTIONS_TOTAL = "system_exceptions_total";
    public static final String SINK_EXCEPTIONS_TOTAL = "sink_exceptions_total";
    public static final String LAST_INVOCATION = "last_invocation";
    public static final String RECEIVED_TOTAL = "received_total";
    public static final String WRITTEN_TOTAL = "written_total";
    public static final String SYSTEM_EXCEPTIONS_TOTAL_1min = "system_exceptions_total_1min";
    public static final String SINK_EXCEPTIONS_TOTAL_1min = "sink_exceptions_total_1min";
    public static final String RECEIVED_TOTAL_1min = "received_total_1min";
    public static final String WRITTEN_TOTAL_1min = "written_total_1min";
    private final Counter statTotalRecordsReceived;
    private final Counter statTotalSysExceptions;
    private final Counter statTotalSinkExceptions;
    private final Counter statTotalWritten;
    private final Gauge statlastInvocation;
    private final Counter statTotalRecordsReceived1min;
    private final Counter statTotalSysExceptions1min;
    private final Counter statTotalSinkExceptions1min;
    private final Counter statTotalWritten1min;
    final Gauge sysExceptions;
    final Gauge sinkExceptions;
    private final Counter.Child _statTotalRecordsReceived;
    private final Counter.Child _statTotalSysExceptions;
    private final Counter.Child _statTotalSinkExceptions;
    private final Counter.Child _statTotalWritten;
    private final Gauge.Child _statlastInvocation;
    private Counter.Child _statTotalRecordsReceived1min;
    private Counter.Child _statTotalSysExceptions1min;
    private Counter.Child _statTotalSinkExceptions1min;
    private Counter.Child _statTotalWritten1min;
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSystemExceptions = EvictingQueue.create((int)10);
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSinkExceptions = EvictingQueue.create((int)10);
    private final RateLimiter sysExceptionRateLimiter;
    private final RateLimiter sinkExceptionRateLimiter;

    public SinkStatsManager(FunctionCollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService) {
        super(collectorRegistry, metricsLabels, scheduledExecutorService);
        this.statTotalRecordsReceived = collectorRegistry.registerIfNotExist("pulsar_sink_received_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_received_total")).help("Total number of records sink has received from Pulsar topic(s).")).labelNames(metricsLabelNames)).create());
        this._statTotalRecordsReceived = (Counter.Child)this.statTotalRecordsReceived.labels(metricsLabels);
        this.statTotalSysExceptions = collectorRegistry.registerIfNotExist("pulsar_sink_system_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_system_exceptions_total")).help("Total number of system exceptions.")).labelNames(metricsLabelNames)).create());
        this._statTotalSysExceptions = (Counter.Child)this.statTotalSysExceptions.labels(metricsLabels);
        this.statTotalSinkExceptions = collectorRegistry.registerIfNotExist("pulsar_sink_sink_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_sink_exceptions_total")).help("Total number of sink exceptions.")).labelNames(metricsLabelNames)).create());
        this._statTotalSinkExceptions = (Counter.Child)this.statTotalSinkExceptions.labels(metricsLabels);
        this.statTotalWritten = collectorRegistry.registerIfNotExist("pulsar_sink_written_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_written_total")).help("Total number of records processed by sink.")).labelNames(metricsLabelNames)).create());
        this._statTotalWritten = (Counter.Child)this.statTotalWritten.labels(metricsLabels);
        this.statlastInvocation = collectorRegistry.registerIfNotExist("pulsar_sink_last_invocation", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_sink_last_invocation")).help("The timestamp of the last invocation of the sink.")).labelNames(metricsLabelNames)).create());
        this._statlastInvocation = (Gauge.Child)this.statlastInvocation.labels(metricsLabels);
        this.statTotalRecordsReceived1min = collectorRegistry.registerIfNotExist("pulsar_sink_received_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_received_total_1min")).help("Total number of messages sink has received from Pulsar topic(s) in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalRecordsReceived1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(metricsLabels);
        this.statTotalSysExceptions1min = collectorRegistry.registerIfNotExist("pulsar_sink_system_exceptions_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_system_exceptions_total_1min")).help("Total number of system exceptions in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalSysExceptions1min = (Counter.Child)this.statTotalSysExceptions1min.labels(metricsLabels);
        this.statTotalSinkExceptions1min = collectorRegistry.registerIfNotExist("pulsar_sink_sink_exceptions_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_sink_exceptions_total_1min")).help("Total number of sink exceptions in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalSinkExceptions1min = (Counter.Child)this.statTotalSinkExceptions1min.labels(metricsLabels);
        this.statTotalWritten1min = collectorRegistry.registerIfNotExist("pulsar_sink_written_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_sink_written_total_1min")).help("Total number of records processed by sink the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalWritten1min = (Counter.Child)this.statTotalWritten1min.labels(metricsLabels);
        this.sysExceptions = collectorRegistry.registerIfNotExist("pulsar_sink_system_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_sink_system_exception")).labelNames(exceptionMetricsLabelNames)).help("Exception from system code.")).create());
        this.sinkExceptions = collectorRegistry.registerIfNotExist("pulsar_sink_sink_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_sink_sink_exception")).labelNames(exceptionMetricsLabelNames)).help("Exception from sink.")).create());
        this.sysExceptionRateLimiter = RateLimiter.builder().scheduledExecutorService(scheduledExecutorService).permits(5L).rateTime(1L).timeUnit(TimeUnit.MINUTES).build();
        this.sinkExceptionRateLimiter = RateLimiter.builder().scheduledExecutorService(scheduledExecutorService).permits(5L).rateTime(1L).timeUnit(TimeUnit.MINUTES).build();
    }

    @Override
    public void reset() {
        this.statTotalRecordsReceived1min.clear();
        this._statTotalRecordsReceived1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(this.metricsLabels);
        this.statTotalSysExceptions1min.clear();
        this._statTotalSysExceptions1min = (Counter.Child)this.statTotalSysExceptions1min.labels(this.metricsLabels);
        this.statTotalSinkExceptions1min.clear();
        this._statTotalSinkExceptions1min = (Counter.Child)this.statTotalSinkExceptions1min.labels(this.metricsLabels);
        this.statTotalWritten1min.clear();
        this._statTotalWritten1min = (Counter.Child)this.statTotalWritten1min.labels(this.metricsLabels);
    }

    @Override
    public void incrTotalReceived() {
        this._statTotalRecordsReceived.inc();
        this._statTotalRecordsReceived1min.inc();
    }

    @Override
    public void incrTotalProcessedSuccessfully() {
        this._statTotalWritten.inc();
        this._statTotalWritten1min.inc();
    }

    @Override
    public void incrSysExceptions(Throwable ex) {
        this._statTotalSysExceptions.inc();
        this._statTotalSysExceptions1min.inc();
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSystemExceptions.add((Object)info);
        if (this.sysExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sysExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    @Override
    public void incrUserExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void incrSourceExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void incrSinkExceptions(Throwable ex) {
        this._statTotalSinkExceptions.inc();
        this._statTotalSinkExceptions1min.inc();
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSinkExceptions.add((Object)info);
        if (this.sinkExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sinkExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    private String[] getExceptionMetricsLabels(Throwable ex) {
        String[] exceptionMetricsLabels = Arrays.copyOf(this.metricsLabels, this.metricsLabels.length + 1);
        exceptionMetricsLabels[exceptionMetricsLabels.length - 1] = ex.getMessage() != null ? ex.getMessage() : "";
        return exceptionMetricsLabels;
    }

    @Override
    public void setLastInvocation(long ts) {
        this._statlastInvocation.set((double)ts);
    }

    @Override
    public void processTimeStart() {
    }

    @Override
    public void processTimeEnd() {
    }

    @Override
    public double getTotalProcessedSuccessfully() {
        return this._statTotalWritten.get();
    }

    @Override
    public double getTotalRecordsReceived() {
        return this._statTotalRecordsReceived.get();
    }

    @Override
    public double getTotalSysExceptions() {
        return this._statTotalSysExceptions.get();
    }

    @Override
    public double getTotalUserExceptions() {
        return 0.0;
    }

    @Override
    public double getLastInvocation() {
        return this._statlastInvocation.get();
    }

    @Override
    public double getAvgProcessLatency() {
        return 0.0;
    }

    @Override
    public double getTotalProcessedSuccessfully1min() {
        return this._statTotalWritten1min.get();
    }

    @Override
    public double getTotalRecordsReceived1min() {
        return this._statTotalRecordsReceived1min.get();
    }

    @Override
    public double getTotalSysExceptions1min() {
        return this._statTotalSysExceptions1min.get();
    }

    @Override
    public double getTotalUserExceptions1min() {
        return 0.0;
    }

    @Override
    public double getAvgProcessLatency1min() {
        return 0.0;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestUserExceptions() {
        return this.EMPTY_QUEUE;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSystemExceptions() {
        return this.latestSystemExceptions;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSourceExceptions() {
        return this.EMPTY_QUEUE;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSinkExceptions() {
        return this.latestSinkExceptions;
    }
}

