/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperBkClientFactoryImpl
implements ZooKeeperClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperBkClientFactoryImpl.class);
    private final OrderedExecutor executor;

    public ZookeeperBkClientFactoryImpl(OrderedExecutor executor) {
        this.executor = executor;
    }

    @Override
    public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
        CompletableFuture<ZooKeeper> future = new CompletableFuture<ZooKeeper>();
        this.executor.execute((Runnable)SafeRunnable.safeRun(() -> {
            try {
                ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString(serverList).sessionTimeoutMs(zkSessionTimeoutMillis).connectRetryPolicy((RetryPolicy)new BoundExponentialBackoffRetryPolicy((long)zkSessionTimeoutMillis, (long)zkSessionTimeoutMillis, 0)).build();
                if (zk.getState() == ZooKeeper.States.CONNECTEDREADONLY && sessionType != ZooKeeperClientFactory.SessionType.AllowReadOnly) {
                    zk.close();
                    future.completeExceptionally(new IllegalStateException("Cannot use a read-only session"));
                }
                log.info("ZooKeeper session established: {}", (Object)zk);
                future.complete((ZooKeeper)zk);
            }
            catch (IOException | InterruptedException | KeeperException exception) {
                log.error("Failed to establish ZooKeeper session: {}", (Object)exception.getMessage());
                future.completeExceptionally(exception);
            }
        }, throwable -> future.completeExceptionally((Throwable)throwable)));
        return future;
    }
}

