/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.prestosql.spi.block.PageBuilderStatus;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BlockBuilderStatus {
    public static final int INSTANCE_SIZE = BlockBuilderStatus.deepInstanceSize(BlockBuilderStatus.class);
    private final PageBuilderStatus pageBuilderStatus;
    private int currentSize;

    BlockBuilderStatus(PageBuilderStatus pageBuilderStatus) {
        this.pageBuilderStatus = Objects.requireNonNull(pageBuilderStatus, "pageBuilderStatus must not be null");
    }

    public int getMaxPageSizeInBytes() {
        return this.pageBuilderStatus.getMaxPageSizeInBytes();
    }

    public void addBytes(int bytes) {
        this.currentSize += bytes;
        this.pageBuilderStatus.addBytes(bytes);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }

    private static int deepInstanceSize(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException(String.format("Cannot determine size of %s because it contains an array", clazz.getSimpleName()));
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException(String.format("%s is an interface", clazz.getSimpleName()));
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s is abstract", clazz.getSimpleName()));
        }
        if (!clazz.getSuperclass().equals(Object.class)) {
            throw new IllegalArgumentException(String.format("Cannot determine size of a subclass. %s extends from %s", clazz.getSimpleName(), clazz.getSuperclass().getSimpleName()));
        }
        int size = ClassLayout.parseClass(clazz).instanceSize();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType().isPrimitive()) continue;
            size += BlockBuilderStatus.deepInstanceSize(field.getType());
        }
        return size;
    }
}

