/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTablePartitioning;
import io.prestosql.spi.connector.DiscretePredicates;
import io.prestosql.spi.connector.LocalProperty;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorTableProperties {
    private final TupleDomain<ColumnHandle> predicate;
    private final Optional<ConnectorTablePartitioning> tablePartitioning;
    private final Optional<Set<ColumnHandle>> streamPartitioningColumns;
    private final Optional<DiscretePredicates> discretePredicates;
    private final List<LocalProperty<ColumnHandle>> localProperties;

    public ConnectorTableProperties() {
        this(TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    }

    @Deprecated
    public ConnectorTableProperties(ConnectorTableLayout layout) {
        this(layout.getPredicate(), layout.getTablePartitioning(), layout.getStreamPartitioningColumns(), layout.getDiscretePredicates(), layout.getLocalProperties());
    }

    public ConnectorTableProperties(TupleDomain<ColumnHandle> predicate, Optional<ConnectorTablePartitioning> tablePartitioning, Optional<Set<ColumnHandle>> streamPartitioningColumns, Optional<DiscretePredicates> discretePredicates, List<LocalProperty<ColumnHandle>> localProperties) {
        Objects.requireNonNull(streamPartitioningColumns, "partitioningColumns is null");
        Objects.requireNonNull(tablePartitioning, "tablePartitioning is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(discretePredicates, "discretePredicates is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        this.tablePartitioning = tablePartitioning;
        this.streamPartitioningColumns = streamPartitioningColumns;
        this.predicate = predicate;
        this.discretePredicates = discretePredicates;
        this.localProperties = localProperties;
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.predicate;
    }

    public Optional<ConnectorTablePartitioning> getTablePartitioning() {
        return this.tablePartitioning;
    }

    public Optional<Set<ColumnHandle>> getStreamPartitioningColumns() {
        return this.streamPartitioningColumns;
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.discretePredicates;
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.localProperties;
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.discretePredicates, this.streamPartitioningColumns, this.tablePartitioning, this.localProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorTableProperties other = (ConnectorTableProperties)obj;
        return Objects.equals(this.predicate, other.predicate) && Objects.equals(this.discretePredicates, other.discretePredicates) && Objects.equals(this.streamPartitioningColumns, other.streamPartitioningColumns) && Objects.equals(this.tablePartitioning, other.tablePartitioning) && Objects.equals(this.localProperties, other.localProperties);
    }
}

