/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProjectionApplicationResult<T> {
    private final T handle;
    private final List<ConnectorExpression> projections;
    private final List<Assignment> assignments;

    public ProjectionApplicationResult(T handle, List<ConnectorExpression> projections, List<Assignment> assignments) {
        Objects.requireNonNull(projections, "projections is null");
        Objects.requireNonNull(assignments, "assignments is null");
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.projections = Collections.unmodifiableList(new ArrayList<ConnectorExpression>(projections));
        this.assignments = Collections.unmodifiableList(new ArrayList<Assignment>(assignments));
    }

    public T getHandle() {
        return this.handle;
    }

    public List<ConnectorExpression> getProjections() {
        return this.projections;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public static class Assignment {
        private final String variable;
        private final ColumnHandle column;
        private final Type type;

        public Assignment(String variable, ColumnHandle column, Type type) {
            this.variable = Objects.requireNonNull(variable, "variable is null");
            this.column = Objects.requireNonNull(column, "column is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public String getVariable() {
            return this.variable;
        }

        public ColumnHandle getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }
    }
}

