/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.prestosql.FullConnectorSession;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.dispatcher.DispatchQuery;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class KillQueryProcedure {
    private static final MethodHandle KILL_QUERY = Reflection.methodHandle(KillQueryProcedure.class, "killQuery", String.class, String.class, ConnectorSession.class);
    private final Optional<DispatchManager> dispatchManager;
    private final AccessControl accessControl;

    @Inject
    public KillQueryProcedure(Optional<DispatchManager> dispatchManager, AccessControl accessControl) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @UsedByGeneratedCode
    public void killQuery(String queryId, String message, ConnectorSession session) {
        QueryId query = KillQueryProcedure.parseQueryId(queryId);
        try {
            Preconditions.checkState((boolean)this.dispatchManager.isPresent(), (Object)"No dispatch manager is set. kill_query procedure should be executed on coordinator.");
            DispatchQuery dispatchQuery = this.dispatchManager.get().getQuery(query);
            AccessControlUtil.checkCanKillQueryOwnedBy(((FullConnectorSession)session).getSession().getIdentity(), dispatchQuery.getSession().getUser(), this.accessControl);
            if (dispatchQuery.isDone()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target query is not running: " + queryId);
            }
            dispatchQuery.fail(KillQueryProcedure.createKillQueryException(message));
            Preconditions.checkState((boolean)dispatchQuery.isDone(), (String)"Failure to fail the query: %s", (Object)query);
            if (!StandardErrorCode.ADMINISTRATIVELY_KILLED.toErrorCode().equals(dispatchQuery.getErrorCode().orElse(null))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target query is not running: " + queryId);
            }
        }
        catch (NoSuchElementException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Target query not found: " + queryId);
        }
    }

    public Procedure getProcedure() {
        return new Procedure("runtime", "kill_query", (List)ImmutableList.builder().add((Object)new Procedure.Argument("query_id", (Type)VarcharType.VARCHAR)).add((Object)new Procedure.Argument("message", (Type)VarcharType.VARCHAR)).build(), KILL_QUERY.bindTo(this));
    }

    public static PrestoException createKillQueryException(String message) {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_KILLED, "Query killed. " + (Strings.isNullOrEmpty((String)message) ? "No message provided." : "Message: " + message));
    }

    public static PrestoException createPreemptQueryException(String message) {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_PREEMPTED, "Query preempted. " + (Strings.isNullOrEmpty((String)message) ? "No message provided." : "Message: " + message));
    }

    private static QueryId parseQueryId(String queryId) {
        try {
            return QueryId.valueOf((String)queryId);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, (Throwable)e);
        }
    }
}

