/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.prestosql.cost.AggregationStatsRule;
import io.prestosql.cost.AssignUniqueIdStatsRule;
import io.prestosql.cost.ComposableStatsCalculator;
import io.prestosql.cost.EnforceSingleRowStatsRule;
import io.prestosql.cost.ExchangeStatsRule;
import io.prestosql.cost.FilterStatsCalculator;
import io.prestosql.cost.FilterStatsRule;
import io.prestosql.cost.JoinStatsRule;
import io.prestosql.cost.LimitStatsRule;
import io.prestosql.cost.OutputStatsRule;
import io.prestosql.cost.ProjectStatsRule;
import io.prestosql.cost.RowNumberStatsRule;
import io.prestosql.cost.ScalarStatsCalculator;
import io.prestosql.cost.SemiJoinStatsRule;
import io.prestosql.cost.SimpleFilterProjectSemiJoinStatsRule;
import io.prestosql.cost.SortStatsRule;
import io.prestosql.cost.SpatialJoinStatsRule;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.TableScanStatsRule;
import io.prestosql.cost.UnionStatsRule;
import io.prestosql.cost.ValuesStatsRule;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.TypeAnalyzer;
import java.util.List;
import javax.inject.Singleton;

public class StatsCalculatorModule
implements Module {
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public static StatsCalculator createNewStatsCalculator(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        StatsNormalizer normalizer = new StatsNormalizer();
        ScalarStatsCalculator scalarStatsCalculator = new ScalarStatsCalculator(metadata, typeAnalyzer);
        FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(metadata, scalarStatsCalculator, normalizer);
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)new OutputStatsRule());
        rules.add((Object)new TableScanStatsRule(metadata, normalizer));
        rules.add((Object)new SimpleFilterProjectSemiJoinStatsRule(metadata, normalizer, filterStatsCalculator));
        rules.add((Object)new FilterStatsRule(normalizer, filterStatsCalculator));
        rules.add((Object)new ValuesStatsRule(metadata));
        rules.add((Object)new LimitStatsRule(normalizer));
        rules.add((Object)new EnforceSingleRowStatsRule(normalizer));
        rules.add((Object)new ProjectStatsRule(scalarStatsCalculator, normalizer));
        rules.add((Object)new ExchangeStatsRule(normalizer));
        rules.add((Object)new JoinStatsRule(filterStatsCalculator, normalizer));
        rules.add((Object)new SpatialJoinStatsRule(filterStatsCalculator, normalizer));
        rules.add((Object)new AggregationStatsRule(normalizer));
        rules.add((Object)new UnionStatsRule(normalizer));
        rules.add((Object)new AssignUniqueIdStatsRule());
        rules.add((Object)new SemiJoinStatsRule());
        rules.add((Object)new RowNumberStatsRule(normalizer));
        rules.add((Object)new SortStatsRule());
        return new ComposableStatsCalculator((List<ComposableStatsCalculator.Rule<?>>)rules.build());
    }
}

