/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.operator.aggregation.AggregationFromAnnotationsParser;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import java.util.List;
import java.util.Objects;

public abstract class SqlAggregationFunction
implements SqlFunction {
    private final FunctionMetadata functionMetadata;
    private final boolean orderSensitive;
    private final boolean decomposable;

    public static List<SqlAggregationFunction> createFunctionByAnnotations(Class<?> aggregationDefinition) {
        return ImmutableList.of((Object)AggregationFromAnnotationsParser.parseFunctionDefinition(aggregationDefinition));
    }

    public static List<SqlAggregationFunction> createFunctionsByAnnotations(Class<?> aggregationDefinition) {
        return (List)AggregationFromAnnotationsParser.parseFunctionDefinitions(aggregationDefinition).stream().map(x -> x).collect(ImmutableList.toImmutableList());
    }

    protected SqlAggregationFunction(FunctionMetadata functionMetadata, boolean decomposable, boolean orderSensitive) {
        this.functionMetadata = Objects.requireNonNull(functionMetadata, "functionMetadata is null");
        Preconditions.checkArgument((boolean)functionMetadata.isDeterministic(), (Object)"Aggregation function must be deterministic");
        this.orderSensitive = orderSensitive;
        this.decomposable = decomposable;
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isDecomposable() {
        return this.decomposable;
    }

    public abstract InternalAggregationFunction specialize(BoundVariables var1, int var2, Metadata var3);
}

