/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.geospatial.Rectangle;
import io.prestosql.geospatial.serde.GeometrySerde;
import io.prestosql.operator.PagesRTreeIndex;
import io.prestosql.operator.PagesSpatialIndex;
import io.prestosql.operator.SpatialIndexBuilderOperator;
import io.prestosql.operator.SyntheticAddress;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinFilterFunctionCompiler;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.STRtree;
import org.openjdk.jol.info.ClassLayout;

public class PagesSpatialIndexSupplier
implements Supplier<PagesSpatialIndex> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PagesSpatialIndexSupplier.class).instanceSize();
    private static final int ENVELOPE_INSTANCE_SIZE = ClassLayout.parseClass(org.locationtech.jts.geom.Envelope.class).instanceSize();
    private static final int STRTREE_INSTANCE_SIZE = ClassLayout.parseClass(STRtree.class).instanceSize();
    private static final int ABSTRACT_NODE_INSTANCE_SIZE = ClassLayout.parseClass(AbstractNode.class).instanceSize();
    private final Session session;
    private final LongArrayList addresses;
    private final List<Type> types;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final Optional<Integer> radiusChannel;
    private final SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final STRtree rtree;
    private final Map<Integer, Rectangle> partitions;
    private final long memorySizeInBytes;

    public PagesSpatialIndexSupplier(Session session, LongArrayList addresses, List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, int geometryChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Map<Integer, Rectangle> partitions) {
        this.session = session;
        this.addresses = addresses;
        this.types = types;
        this.outputChannels = outputChannels;
        this.channels = channels;
        this.spatialRelationshipTest = spatialRelationshipTest;
        this.filterFunctionFactory = filterFunctionFactory;
        this.partitions = partitions;
        this.rtree = PagesSpatialIndexSupplier.buildRTree(addresses, channels, geometryChannel, radiusChannel, partitionChannel);
        this.radiusChannel = radiusChannel;
        this.memorySizeInBytes = (long)INSTANCE_SIZE + (this.rtree.isEmpty() ? 0L : (long)STRTREE_INSTANCE_SIZE + this.computeMemorySizeInBytes(this.rtree.getRoot()));
    }

    private static STRtree buildRTree(LongArrayList addresses, List<List<Block>> channels, int geometryChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel) {
        STRtree rtree = new STRtree();
        Operator relateOperator = OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Relate);
        for (int position = 0; position < addresses.size(); ++position) {
            double radius;
            long pageAddress = addresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            Block block = channels.get(geometryChannel).get(blockIndex);
            if (block.isNull(blockPosition)) continue;
            Slice slice = block.getSlice(blockPosition, 0, block.getSliceLength(blockPosition));
            OGCGeometry ogcGeometry = GeometrySerde.deserialize((Slice)slice);
            Verify.verifyNotNull((Object)ogcGeometry);
            if (ogcGeometry.isEmpty() || (radius = radiusChannel.map(channel -> DoubleType.DOUBLE.getDouble((Block)((List)channels.get((int)channel)).get(blockIndex), blockPosition)).orElse(0.0).doubleValue()) < 0.0) continue;
            if (!radiusChannel.isPresent()) {
                PagesSpatialIndexSupplier.accelerateGeometry(ogcGeometry, relateOperator);
            }
            int partition = -1;
            if (partitionChannel.isPresent()) {
                Block partitionBlock = channels.get(partitionChannel.get()).get(blockIndex);
                partition = Math.toIntExact(IntegerType.INTEGER.getLong(partitionBlock, blockPosition));
            }
            rtree.insert(PagesSpatialIndexSupplier.getEnvelope(ogcGeometry, radius), (Object)new PagesRTreeIndex.GeometryWithPosition(ogcGeometry, partition, position));
        }
        rtree.build();
        return rtree;
    }

    private static org.locationtech.jts.geom.Envelope getEnvelope(OGCGeometry ogcGeometry, double radius) {
        Envelope envelope = new Envelope();
        ogcGeometry.getEsriGeometry().queryEnvelope(envelope);
        return new org.locationtech.jts.geom.Envelope(envelope.getXMin() - radius, envelope.getXMax() + radius, envelope.getYMin() - radius, envelope.getYMax() + radius);
    }

    private long computeMemorySizeInBytes(AbstractNode root) {
        if (root.getLevel() == 0) {
            return (long)(ABSTRACT_NODE_INSTANCE_SIZE + ENVELOPE_INSTANCE_SIZE) + root.getChildBoundables().stream().mapToLong(child -> this.computeMemorySizeInBytes((ItemBoundable)child)).sum();
        }
        return (long)(ABSTRACT_NODE_INSTANCE_SIZE + ENVELOPE_INSTANCE_SIZE) + root.getChildBoundables().stream().mapToLong(child -> this.computeMemorySizeInBytes((AbstractNode)child)).sum();
    }

    private long computeMemorySizeInBytes(ItemBoundable item) {
        return (long)ENVELOPE_INSTANCE_SIZE + ((PagesRTreeIndex.GeometryWithPosition)item.getItem()).getEstimatedMemorySizeInBytes();
    }

    private static void accelerateGeometry(OGCGeometry ogcGeometry, Operator relateOperator) {
        Geometry esriGeometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        while ((esriGeometry = cursor.next()) != null) {
            relateOperator.accelerateGeometry(esriGeometry, null, Geometry.GeometryAccelerationDegree.enumMild);
        }
    }

    public DataSize getEstimatedSize() {
        return DataSize.ofBytes((long)this.memorySizeInBytes);
    }

    @Override
    public PagesSpatialIndex get() {
        if (this.rtree.isEmpty()) {
            return PagesSpatialIndex.EMPTY_INDEX;
        }
        return new PagesRTreeIndex(this.session, this.addresses, this.types, this.outputChannels, this.channels, this.rtree, this.radiusChannel, this.spatialRelationshipTest, this.filterFunctionFactory, this.partitions);
    }
}

