/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.PageUtils;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.SourceOperatorFactory;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorSourceOperator;
import io.prestosql.operator.WorkProcessorSourceOperatorAdapter;
import io.prestosql.operator.project.CursorProcessor;
import io.prestosql.operator.project.CursorProcessorOutput;
import io.prestosql.operator.project.MergePages;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.EmptyPageSource;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.split.EmptySplit;
import io.prestosql.split.PageSourceProvider;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ScanFilterAndProjectOperator
implements WorkProcessorSourceOperator {
    private final WorkProcessor<Page> pages;
    @Nullable
    private RecordCursor cursor;
    @Nullable
    private ConnectorPageSource pageSource;
    private long processedPositions;
    private long processedBytes;
    private long physicalBytes;
    private long readTimeNanos;
    private long dynamicFilterSplitsProcessed;

    private ScanFilterAndProjectOperator(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, Supplier<TupleDomain<ColumnHandle>> dynamicFilter, Iterable<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount, boolean avoidPageMaterialization) {
        this.pages = splits.flatTransform(new SplitToPages(session, yieldSignal, pageSourceProvider, cursorProcessor, pageProcessor, table, columns, dynamicFilter, types, Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null").aggregateSystemMemoryContext(), minOutputPageSize, minOutputPageRowCount, avoidPageMaterialization));
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> getUpdatablePageSourceSupplier() {
        return () -> {
            if (this.pageSource instanceof UpdatablePageSource) {
                return Optional.of((UpdatablePageSource)this.pageSource);
            }
            return Optional.empty();
        };
    }

    @Override
    public DataSize getPhysicalInputDataSize() {
        return DataSize.ofBytes((long)this.physicalBytes);
    }

    @Override
    public long getPhysicalInputPositions() {
        return this.processedPositions;
    }

    @Override
    public DataSize getInputDataSize() {
        return DataSize.ofBytes((long)this.processedBytes);
    }

    @Override
    public long getInputPositions() {
        return this.processedPositions;
    }

    @Override
    public Duration getReadTime() {
        return new Duration((double)this.readTimeNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDynamicFilterSplitsProcessed() {
        return this.dynamicFilterSplitsProcessed;
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public void close() {
        if (this.pageSource != null) {
            try {
                this.pageSource.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory,
    WorkProcessorSourceOperatorAdapter.AdapterWorkProcessorSourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<CursorProcessor> cursorProcessor;
        private final Supplier<PageProcessor> pageProcessor;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final TableHandle table;
        private final List<ColumnHandle> columns;
        private final Supplier<TupleDomain<ColumnHandle>> dynamicFilter;
        private final List<Type> types;
        private final DataSize minOutputPageSize;
        private final int minOutputPageRowCount;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, Supplier<CursorProcessor> cursorProcessor, Supplier<PageProcessor> pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, Supplier<TupleDomain<ColumnHandle>> dynamicFilter, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.dynamicFilter = dynamicFilter;
            this.types = Objects.requireNonNull(types, "types is null");
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return ScanFilterAndProjectOperator.class.getSimpleName();
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, this.getOperatorType());
            return new WorkProcessorSourceOperatorAdapter(operatorContext, this);
        }

        @Override
        public WorkProcessorSourceOperator create(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits) {
            return this.create(session, memoryTrackingContext, yieldSignal, splits, true);
        }

        @Override
        public WorkProcessorSourceOperator createAdapterOperator(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits) {
            return this.create(session, memoryTrackingContext, yieldSignal, splits, false);
        }

        private ScanFilterAndProjectOperator create(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits, boolean avoidPageMaterialization) {
            return new ScanFilterAndProjectOperator(session, memoryTrackingContext, yieldSignal, splits, this.pageSourceProvider, this.cursorProcessor.get(), this.pageProcessor.get(), this.table, this.columns, this.dynamicFilter, this.types, this.minOutputPageSize, this.minOutputPageRowCount, avoidPageMaterialization);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }

    private class ConnectorPageSourceToPages
    implements WorkProcessor.Process<Page> {
        final LocalMemoryContext pageSourceMemoryContext;

        ConnectorPageSourceToPages(LocalMemoryContext pageSourceMemoryContext) {
            this.pageSourceMemoryContext = pageSourceMemoryContext;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (ScanFilterAndProjectOperator.this.pageSource.isFinished()) {
                return WorkProcessor.ProcessState.finished();
            }
            CompletableFuture isBlocked = ScanFilterAndProjectOperator.this.pageSource.isBlocked();
            if (!isBlocked.isDone()) {
                return WorkProcessor.ProcessState.blocked(MoreFutures.toListenableFuture((CompletableFuture)isBlocked));
            }
            Page page = ScanFilterAndProjectOperator.this.pageSource.getNextPage();
            this.pageSourceMemoryContext.setBytes(ScanFilterAndProjectOperator.this.pageSource.getSystemMemoryUsage());
            if (page == null) {
                if (ScanFilterAndProjectOperator.this.pageSource.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                return WorkProcessor.ProcessState.yield();
            }
            PageUtils.recordMaterializedBytes(page, sizeInBytes -> ScanFilterAndProjectOperator.this.processedBytes = ScanFilterAndProjectOperator.this.processedBytes + sizeInBytes);
            ScanFilterAndProjectOperator.this.processedPositions = ScanFilterAndProjectOperator.this.processedPositions + (long)page.getPositionCount();
            ScanFilterAndProjectOperator.this.physicalBytes = ScanFilterAndProjectOperator.this.pageSource.getCompletedBytes();
            ScanFilterAndProjectOperator.this.readTimeNanos = ScanFilterAndProjectOperator.this.pageSource.getReadTimeNanos();
            return WorkProcessor.ProcessState.ofResult(page);
        }
    }

    private class RecordCursorToPages
    implements WorkProcessor.Process<Page> {
        final Session session;
        final DriverYieldSignal yieldSignal;
        final CursorProcessor cursorProcessor;
        final PageBuilder pageBuilder;
        final LocalMemoryContext pageSourceMemoryContext;
        final LocalMemoryContext outputMemoryContext;
        boolean finished;

        RecordCursorToPages(Session session, DriverYieldSignal yieldSignal, CursorProcessor cursorProcessor, List<Type> types, LocalMemoryContext pageSourceMemoryContext, LocalMemoryContext outputMemoryContext) {
            this.session = session;
            this.yieldSignal = yieldSignal;
            this.cursorProcessor = cursorProcessor;
            this.pageBuilder = new PageBuilder(types);
            this.pageSourceMemoryContext = pageSourceMemoryContext;
            this.outputMemoryContext = outputMemoryContext;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (!this.finished) {
                CursorProcessorOutput output = this.cursorProcessor.process(this.session.toConnectorSession(), this.yieldSignal, ScanFilterAndProjectOperator.this.cursor, this.pageBuilder);
                this.pageSourceMemoryContext.setBytes(ScanFilterAndProjectOperator.this.cursor.getSystemMemoryUsage());
                ScanFilterAndProjectOperator.this.processedPositions = ScanFilterAndProjectOperator.this.processedPositions + (long)output.getProcessedRows();
                ScanFilterAndProjectOperator.this.processedBytes = ScanFilterAndProjectOperator.this.cursor.getCompletedBytes();
                ScanFilterAndProjectOperator.this.physicalBytes = ScanFilterAndProjectOperator.this.cursor.getCompletedBytes();
                ScanFilterAndProjectOperator.this.readTimeNanos = ScanFilterAndProjectOperator.this.cursor.getReadTimeNanos();
                if (output.isNoMoreRows()) {
                    this.finished = true;
                }
            }
            if (this.pageBuilder.isFull() || this.finished && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
                return WorkProcessor.ProcessState.ofResult(page);
            }
            if (this.finished) {
                Preconditions.checkState((boolean)this.pageBuilder.isEmpty());
                return WorkProcessor.ProcessState.finished();
            }
            this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return WorkProcessor.ProcessState.yield();
        }
    }

    private class SplitToPages
    implements WorkProcessor.Transformation<Split, WorkProcessor<Page>> {
        final Session session;
        final DriverYieldSignal yieldSignal;
        final PageSourceProvider pageSourceProvider;
        final CursorProcessor cursorProcessor;
        final PageProcessor pageProcessor;
        final TableHandle table;
        final List<ColumnHandle> columns;
        final Supplier<TupleDomain<ColumnHandle>> dynamicFilter;
        final List<Type> types;
        final LocalMemoryContext memoryContext;
        final AggregatedMemoryContext localAggregatedMemoryContext;
        final LocalMemoryContext pageSourceMemoryContext;
        final LocalMemoryContext outputMemoryContext;
        final DataSize minOutputPageSize;
        final int minOutputPageRowCount;
        final boolean avoidPageMaterialization;

        SplitToPages(Session session, DriverYieldSignal yieldSignal, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, Supplier<TupleDomain<ColumnHandle>> dynamicFilter, Iterable<Type> types, AggregatedMemoryContext aggregatedMemoryContext, DataSize minOutputPageSize, int minOutputPageRowCount, boolean avoidPageMaterialization) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.yieldSignal = Objects.requireNonNull(yieldSignal, "yieldSignal is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.dynamicFilter = dynamicFilter;
            this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
            this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.localAggregatedMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            this.pageSourceMemoryContext = this.localAggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.outputMemoryContext = this.localAggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
            this.avoidPageMaterialization = avoidPageMaterialization;
        }

        @Override
        public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Split split) {
            Object source;
            if (split == null) {
                this.memoryContext.close();
                return WorkProcessor.TransformationState.finished();
            }
            Preconditions.checkState((ScanFilterAndProjectOperator.this.cursor == null && ScanFilterAndProjectOperator.this.pageSource == null ? 1 : 0) != 0, (Object)"Table scan split already set");
            if (!this.dynamicFilter.get().isAll()) {
                ScanFilterAndProjectOperator.this.dynamicFilterSplitsProcessed++;
            }
            if ((source = split.getConnectorSplit() instanceof EmptySplit ? new EmptyPageSource() : this.pageSourceProvider.createPageSource(this.session, split, this.table, this.columns, this.dynamicFilter)) instanceof RecordPageSource) {
                ScanFilterAndProjectOperator.this.cursor = ((RecordPageSource)source).getCursor();
                return WorkProcessor.TransformationState.ofResult(this.processColumnSource());
            }
            ScanFilterAndProjectOperator.this.pageSource = (ConnectorPageSource)source;
            return WorkProcessor.TransformationState.ofResult(this.processPageSource());
        }

        WorkProcessor<Page> processColumnSource() {
            return WorkProcessor.create(new RecordCursorToPages(this.session, this.yieldSignal, this.cursorProcessor, this.types, this.pageSourceMemoryContext, this.outputMemoryContext)).yielding(this.yieldSignal::isSet).withProcessStateMonitor(state -> this.memoryContext.setBytes(this.localAggregatedMemoryContext.getBytes()));
        }

        WorkProcessor<Page> processPageSource() {
            return WorkProcessor.create(new ConnectorPageSourceToPages(this.pageSourceMemoryContext)).yielding(this.yieldSignal::isSet).flatMap(page -> this.pageProcessor.createWorkProcessor(this.session.toConnectorSession(), this.yieldSignal, this.outputMemoryContext, (Page)page, this.avoidPageMaterialization)).transformProcessor(processor -> MergePages.mergePages(this.types, this.minOutputPageSize.toBytes(), this.minOutputPageRowCount, processor, this.localAggregatedMemoryContext)).withProcessStateMonitor(state -> this.memoryContext.setBytes(this.localAggregatedMemoryContext.getBytes()));
        }
    }
}

