/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class TableDeleteOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final Metadata metadata;
    private final Session session;
    private final TableHandle tableHandle;
    private boolean finished;

    public TableDeleteOperator(OperatorContext operatorContext, Metadata metadata, Session session, TableHandle tableHandle) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        this.finished = true;
        OptionalLong rowsDeletedCount = this.metadata.executeDelete(this.session, this.tableHandle);
        PageBuilder page = new PageBuilder(1, TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        page.declarePosition();
        if (rowsDeletedCount.isPresent()) {
            BigintType.BIGINT.writeLong(rowsBuilder, rowsDeletedCount.getAsLong());
        } else {
            rowsBuilder.appendNull();
        }
        return page.build();
    }

    public static class TableDeleteOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Metadata metadata;
        private final Session session;
        private final TableHandle tableHandle;
        private boolean closed;

        public TableDeleteOperatorFactory(int operatorId, PlanNodeId planNodeId, Metadata metadata, Session session, TableHandle tableHandle) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableDeleteOperator.class.getSimpleName());
            return new TableDeleteOperator(context, this.metadata, this.session, this.tableHandle);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableDeleteOperatorFactory(this.operatorId, this.planNodeId, this.metadata, this.session, this.tableHandle);
        }
    }
}

