/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.BlockComparator;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.TypedHeap;
import io.prestosql.operator.aggregation.state.MinMaxNState;
import io.prestosql.operator.aggregation.state.MinMaxNStateFactory;
import io.prestosql.operator.aggregation.state.MinMaxNStateSerializer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractMinMaxNAggregationFunction
extends SqlAggregationFunction {
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxNAggregationFunction.class, "input", BlockComparator.class, Type.class, MinMaxNState.class, Block.class, Long.TYPE, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxNAggregationFunction.class, "combine", MinMaxNState.class, MinMaxNState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxNAggregationFunction.class, "output", ArrayType.class, MinMaxNState.class, BlockBuilder.class);
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final Function<Type, BlockComparator> typeToComparator;

    protected AbstractMinMaxNAggregationFunction(String name, Function<Type, BlockComparator> typeToComparator, String description) {
        super(new FunctionMetadata(new Signature(name, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]), (Object)BigintType.BIGINT.getTypeSignature()), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, true, description, FunctionKind.AGGREGATE), true, false);
        Objects.requireNonNull(typeToComparator);
        this.typeToComparator = typeToComparator;
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Type type = boundVariables.getTypeVariable("E");
        return this.generateAggregation(type);
    }

    protected InternalAggregationFunction generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(AbstractMinMaxNAggregationFunction.class.getClassLoader());
        BlockComparator comparator = this.typeToComparator.apply(type);
        ImmutableList inputTypes = ImmutableList.of((Object)type, (Object)BigintType.BIGINT);
        MinMaxNStateSerializer stateSerializer = new MinMaxNStateSerializer(comparator, type);
        Type intermediateType = stateSerializer.getSerializedType();
        ArrayType outputType = new ArrayType(type);
        ImmutableList inputParameterMetadata = ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)BigintType.BIGINT), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
        String name = this.getFunctionMetadata().getSignature().getName();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(name, type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), (List<AggregationMetadata.ParameterMetadata>)inputParameterMetadata, INPUT_FUNCTION.bindTo(comparator).bindTo(type), Optional.empty(), COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(outputType), (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(MinMaxNState.class, stateSerializer, new MinMaxNStateFactory())), (Type)outputType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(name, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)outputType, true, false, factory);
    }

    public static void input(BlockComparator comparator, Type type, MinMaxNState state, Block block, long n, int blockIndex) {
        TypedHeap heap = state.getTypedHeap();
        if (heap == null) {
            if (n <= 0L) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of max_n/min_n must be positive");
            }
            Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of max_n/min_n must be less than or equal to %s; found %s", 10000L, n);
            heap = new TypedHeap(comparator, type, Math.toIntExact(n));
            state.setTypedHeap(heap);
        }
        long startSize = heap.getEstimatedSize();
        heap.add(block, blockIndex);
        state.addMemoryUsage(heap.getEstimatedSize() - startSize);
    }

    public static void combine(MinMaxNState state, MinMaxNState otherState) {
        TypedHeap otherHeap = otherState.getTypedHeap();
        if (otherHeap == null) {
            return;
        }
        TypedHeap heap = state.getTypedHeap();
        if (heap == null) {
            state.setTypedHeap(otherHeap);
            return;
        }
        long startSize = heap.getEstimatedSize();
        heap.addAll(otherHeap);
        state.addMemoryUsage(heap.getEstimatedSize() - startSize);
    }

    public static void output(ArrayType outputType, MinMaxNState state, BlockBuilder out) {
        TypedHeap heap = state.getTypedHeap();
        if (heap == null || heap.isEmpty()) {
            out.appendNull();
            return;
        }
        Type elementType = outputType.getElementType();
        BlockBuilder reversedBlockBuilder = elementType.createBlockBuilder(null, heap.getCapacity());
        long startSize = heap.getEstimatedSize();
        heap.popAll(reversedBlockBuilder);
        state.addMemoryUsage(heap.getEstimatedSize() - startSize);
        BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
        for (int i = reversedBlockBuilder.getPositionCount() - 1; i >= 0; --i) {
            elementType.appendTo((Block)reversedBlockBuilder, i, arrayBlockBuilder);
        }
        out.closeEntry();
    }
}

