/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;

public class NullableLongStateSerializer
implements AccumulatorStateSerializer<NullableLongState> {
    public Type getSerializedType() {
        return BigintType.BIGINT;
    }

    public void serialize(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getLong());
        }
    }

    public void deserialize(Block block, int index, NullableLongState state) {
        state.setNull(false);
        state.setLong(BigintType.BIGINT.getLong(block, index));
    }
}

