/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.prestosql.operator.aggregation.state.TriStateBooleanState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;

public class TriStateBooleanStateSerializer
implements AccumulatorStateSerializer<TriStateBooleanState> {
    public Type getSerializedType() {
        return BooleanType.BOOLEAN;
    }

    public void serialize(TriStateBooleanState state, BlockBuilder out) {
        if (state.getByte() == 0) {
            out.appendNull();
        } else {
            out.writeByte(state.getByte() == 1 ? 1 : 0).closeEntry();
        }
    }

    public void deserialize(Block block, int index, TriStateBooleanState state) {
        state.setByte(BooleanType.BOOLEAN.getBoolean(block, index) ? (byte)1 : -1);
    }
}

