/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.operator.DriverFactory;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.index.DynamicTupleFilterFactory;
import io.prestosql.operator.index.IndexSnapshotBuilder;
import io.prestosql.operator.index.PageBuffer;
import io.prestosql.operator.index.PageBufferOperator;
import io.prestosql.operator.index.PagesIndexBuilderOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class IndexBuildDriverFactoryProvider {
    private final int pipelineId;
    private final int outputOperatorId;
    private final PlanNodeId planNodeId;
    private final boolean inputDriver;
    private final List<OperatorFactory> coreOperatorFactories;
    private final List<Type> outputTypes;
    private final Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory;

    public IndexBuildDriverFactoryProvider(int pipelineId, int outputOperatorId, PlanNodeId planNodeId, boolean inputDriver, List<Type> outputTypes, List<OperatorFactory> coreOperatorFactories, Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory) {
        Objects.requireNonNull(planNodeId, "planNodeId is null");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Objects.requireNonNull(coreOperatorFactories, "coreOperatorFactories is null");
        Preconditions.checkArgument((!coreOperatorFactories.isEmpty() ? 1 : 0) != 0, (Object)"coreOperatorFactories is empty");
        Objects.requireNonNull(dynamicTupleFilterFactory, "dynamicTupleFilterFactory is null");
        this.pipelineId = pipelineId;
        this.outputOperatorId = outputOperatorId;
        this.planNodeId = planNodeId;
        this.inputDriver = inputDriver;
        this.coreOperatorFactories = ImmutableList.copyOf(coreOperatorFactories);
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.dynamicTupleFilterFactory = dynamicTupleFilterFactory;
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public DriverFactory createSnapshot(int pipelineId, IndexSnapshotBuilder indexSnapshotBuilder) {
        Preconditions.checkArgument((boolean)indexSnapshotBuilder.getOutputTypes().equals(this.outputTypes));
        return new DriverFactory(pipelineId, this.inputDriver, false, (List<OperatorFactory>)ImmutableList.builder().addAll(this.coreOperatorFactories).add((Object)new PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory(this.outputOperatorId, this.planNodeId, indexSnapshotBuilder)).build(), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
    }

    public DriverFactory createStreaming(PageBuffer pageBuffer, Page indexKeyTuple) {
        ImmutableList.Builder operatorFactories = ImmutableList.builder().addAll(this.coreOperatorFactories);
        if (this.dynamicTupleFilterFactory.isPresent()) {
            operatorFactories.add((Object)this.dynamicTupleFilterFactory.get().filterWithTuple(indexKeyTuple));
        }
        operatorFactories.add((Object)new PageBufferOperator.PageBufferOperatorFactory(this.outputOperatorId, this.planNodeId, pageBuffer));
        return new DriverFactory(this.pipelineId, this.inputDriver, false, (List<OperatorFactory>)operatorFactories.build(), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
    }
}

