/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;

@ScalarFunction(value="element_at")
@Description(value="Get element of array at given index")
public final class ArrayElementAtFunction {
    private ArrayElementAtFunction() {
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Long longElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Boolean booleanElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Double doubleElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Slice sliceElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Block blockElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return (Block)elementType.getObject(array, position);
    }

    private static int checkedIndexToBlockPosition(Block block, long index) {
        int arrayLength = block.getPositionCount();
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (Math.abs(index) > (long)arrayLength) {
            return -1;
        }
        if (index > 0L) {
            return Math.toIntExact(index - 1L);
        }
        return Math.toIntExact((long)arrayLength + index);
    }
}

