/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

@ScalarFunction(value="array_intersect")
@Description(value="Intersects elements of the two given arrays")
public final class ArrayIntersectFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayIntersectFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block intersect(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() < rightArray.getPositionCount()) {
            Block tempArray = leftArray;
            leftArray = rightArray;
            rightArray = tempArray;
        }
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (rightPositionCount == 0) {
            return rightArray;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        TypedSet rightTypedSet = new TypedSet(type, elementIsDistinctFrom, rightPositionCount, "array_intersect");
        for (int i = 0; i < rightPositionCount; ++i) {
            rightTypedSet.add(rightArray, i);
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        TypedSet intersectTypedSet = new TypedSet(type, Optional.of(elementIsDistinctFrom), blockBuilder, rightPositionCount, "array_intersect");
        for (int i = 0; i < leftPositionCount; ++i) {
            if (!rightTypedSet.contains(leftArray, i)) continue;
            intersectTypedSet.add(leftArray, i);
        }
        this.pageBuilder.declarePositions(intersectTypedSet.size());
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - intersectTypedSet.size(), intersectTypedSet.size());
    }
}

