/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.re2j.Matcher;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.type.Constraint;
import io.prestosql.type.Re2JRegexp;

public final class Re2JRegexpFunctions {
    private Re2JRegexpFunctions() {
    }

    @Description(value="Returns substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean regexpLike(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.matches(source);
    }

    @Description(value="Removes substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="Replaces substrings matching a regular expression by given string")
    @ScalarFunction
    @LiteralParameters(value={"x", "y", "z"})
    @Constraint(variable="z", expression="min(2147483647, x + max(x * y / 2, y) * (x + 1))")
    @SqlType(value="varchar(z)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="varchar(y)") Slice replacement) {
        return pattern.replace(source, replacement);
    }

    @Description(value="String(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array(varchar(x))")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtractAll(source, pattern, 0L);
    }

    @Description(value="Group(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array(varchar(x))")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extractAll(source, groupIndex);
    }

    @SqlNullable
    @Description(value="String extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @SqlNullable
    @Description(value="Returns regex group of extracted string with a pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extract(source, groupIndex);
    }

    @ScalarFunction
    @Description(value="Returns array of strings split by pattern")
    @LiteralParameters(value={"x"})
    @SqlType(value="array(varchar(x))")
    public static Block regexpSplit(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.split(source);
    }

    @ScalarFunction
    @Description(value="Returns the index of the matched substring.")
    @LiteralParameters(value={"x"})
    @SqlType(value="integer")
    public static long regexpPosition(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpPosition(source, pattern, 1L);
    }

    @ScalarFunction
    @Description(value="Returns the index of the matched substring starting from the specified position")
    @LiteralParameters(value={"x"})
    @SqlType(value="integer")
    public static long regexpPosition(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="integer") long start) {
        return Re2JRegexpFunctions.regexpPosition(source, pattern, start, 1L);
    }

    @ScalarFunction
    @Description(value="Returns the index of the n-th matched substring starting from the specified position")
    @LiteralParameters(value={"x"})
    @SqlType(value="integer")
    public static long regexpPosition(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="integer") long start, @SqlType(value="integer") long occurrence) {
        if (start < 1L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "start position cannot be smaller than 1");
        }
        if (occurrence < 1L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "occurrence cannot be smaller than 1");
        }
        if (start > (long)SliceUtf8.countCodePoints((Slice)source)) {
            return -1L;
        }
        int startBytePosition = SliceUtf8.offsetOfCodePoint((Slice)source, (int)((int)start - 1));
        int length = source.length() - startBytePosition;
        Matcher matcher = pattern.matcher(source.slice(startBytePosition, length));
        long count = 0L;
        while (matcher.find()) {
            if (++count != occurrence) continue;
            return SliceUtf8.countCodePoints((Slice)source, (int)0, (int)(startBytePosition + matcher.start())) + 1;
        }
        return -1L;
    }

    @ScalarFunction
    @Description(value="Returns the number of times that a pattern occurs in a string")
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long regexpCount(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        Matcher matcher = pattern.matcher(source);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }
}

