/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.scalar.RowComparisonOperator;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class RowLessThanOrEqualOperator
extends RowComparisonOperator {
    public static final RowLessThanOrEqualOperator ROW_LESS_THAN_OR_EQUAL = new RowLessThanOrEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowLessThanOrEqualOperator.class, "lessOrEqual", RowType.class, List.class, Block.class, Block.class);

    private RowLessThanOrEqualOperator() {
        super(OperatorType.LESS_THAN_OR_EQUAL);
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Type type = boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(type).bindTo(this.getMethodHandles((RowType)type, metadata, OperatorType.LESS_THAN)));
    }

    public static boolean lessOrEqual(RowType rowType, List<MethodHandle> lessThanFunctions, Block leftRow, Block rightRow) {
        int compareResult = RowLessThanOrEqualOperator.compare(rowType, lessThanFunctions, leftRow, rightRow);
        return compareResult >= 0;
    }
}

