/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.base.Strings;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.operator.window.WindowFunctionSupplier;
import java.util.Collections;
import java.util.Objects;

public class SqlWindowFunction
implements SqlFunction {
    private final WindowFunctionSupplier supplier;
    private final FunctionMetadata functionMetadata;

    public SqlWindowFunction(WindowFunctionSupplier supplier, boolean deprecated) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
        Signature signature = supplier.getSignature();
        this.functionMetadata = new FunctionMetadata(signature, true, Collections.nCopies(signature.getArgumentTypes().size(), new FunctionArgumentDefinition(true)), false, true, Strings.nullToEmpty((String)supplier.getDescription()), FunctionKind.WINDOW, deprecated);
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public WindowFunctionSupplier specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        return this.supplier;
    }
}

