/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DenyAllAccessControl
implements AccessControl {
    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
    }

    @Override
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        AccessDeniedException.denyExecuteQuery();
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, String queryOwner) {
        AccessDeniedException.denyViewQuery();
    }

    @Override
    public Set<String> filterQueriesOwnedBy(Identity identity, Set<String> queryOwners) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, String queryOwner) {
        AccessDeniedException.denyKillQuery();
    }

    @Override
    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyCreateSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyDropSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyShowCreateTable((String)tableName.toString());
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext context, CatalogSchemaName schemaName, PrestoPrincipal principal) {
        AccessDeniedException.denySetSchemaAuthorization((String)schemaName.toString(), (PrestoPrincipal)principal);
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyCommentTable((String)tableName.toString());
    }

    @Override
    public void checkCanShowTables(SecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTables((String)schema.toString());
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyShowColumns((String)table.toString());
    }

    @Override
    public List<ColumnMetadata> filterColumns(SecurityContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        return ImmutableList.of();
    }

    @Override
    public void checkCanShowSchemas(SecurityContext context, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    @Override
    public Set<String> filterSchemas(SecurityContext context, String catalogName, Set<String> schemaNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropColumn((String)tableName.toString());
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)context.getIdentity());
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)functionName, (Identity)context.getIdentity(), (Identity)grantee);
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        AccessDeniedException.denySelectColumns((String)tableName.toString(), columnNames);
    }

    @Override
    public void checkCanCreateRole(SecurityContext context, String role, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyCreateRole((String)role);
    }

    @Override
    public void checkCanDropRole(SecurityContext context, String role, String catalogName) {
        AccessDeniedException.denyDropRole((String)role);
    }

    @Override
    public void checkCanGrantRoles(SecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    @Override
    public void checkCanSetRole(SecurityContext context, String role, String catalog) {
        AccessDeniedException.denySetRole((String)role);
    }

    @Override
    public void checkCanShowRoles(SecurityContext context, String catalogName) {
        AccessDeniedException.denyShowRoles((String)catalogName);
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext context, String catalogName) {
        AccessDeniedException.denyShowCurrentRoles((String)catalogName);
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext context, String catalogName) {
        AccessDeniedException.denyShowRoleGrants((String)catalogName);
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext context, QualifiedObjectName procedureName) {
        AccessDeniedException.denyExecuteProcedure((String)procedureName.toString());
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        AccessDeniedException.denyExecuteFunction((String)functionName);
    }
}

