/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.event.client.EventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.jmx.JmxModule;
import io.airlift.json.JsonModule;
import io.airlift.log.LogJmxModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.eventlistener.EventListenerModule;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.execution.warnings.WarningCollectorModule;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.StaticCatalogStore;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.AccessControlModule;
import io.prestosql.security.GroupProviderManager;
import io.prestosql.server.GracefulShutdownModule;
import io.prestosql.server.PluginManager;
import io.prestosql.server.PrefixObjectNameGeneratorModule;
import io.prestosql.server.PrestoSystemRequirements;
import io.prestosql.server.ServerConfig;
import io.prestosql.server.ServerInfoResource;
import io.prestosql.server.ServerMainModule;
import io.prestosql.server.SessionPropertyDefaults;
import io.prestosql.server.security.PasswordAuthenticatorManager;
import io.prestosql.server.security.ServerSecurityModule;
import io.prestosql.version.EmbedVersion;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class PrestoServer
implements Runnable {
    public static void main(String[] args) {
        EmbedVersion embedVersion = new EmbedVersion(new ServerConfig());
        embedVersion.embedVersion(new PrestoServer()::run).run();
    }

    @Override
    public void run() {
        PrestoSystemRequirements.verifyJvmRequirements();
        PrestoSystemRequirements.verifySystemTimeIsReasonable();
        Logger log = Logger.get(PrestoServer.class);
        log.info("Java version: %s", new Object[]{StandardSystemProperty.JAVA_VERSION.value()});
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), new JaxrsModule(), new MBeanModule(), new PrefixObjectNameGeneratorModule("io.prestosql"), new JmxModule(), new JmxHttpModule(), new LogJmxModule(), new TraceTokenModule(), new EventModule(), new JsonEventModule(), new ServerSecurityModule(), new AccessControlModule(), new EventListenerModule(), new ServerMainModule(), new GracefulShutdownModule(), new WarningCollectorModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.strictConfig().initialize();
            PrestoServer.logLocation(log, "Working directory", Paths.get(".", new String[0]));
            PrestoServer.logLocation(log, "Etc directory", Paths.get("etc", new String[0]));
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((StaticCatalogStore)injector.getInstance(StaticCatalogStore.class)).loadCatalogs();
            PrestoServer.updateConnectorIds((Announcer)injector.getInstance(Announcer.class), (CatalogManager)injector.getInstance(CatalogManager.class), (ServerConfig)injector.getInstance(ServerConfig.class), (NodeSchedulerConfig)injector.getInstance(NodeSchedulerConfig.class));
            ((SessionPropertyDefaults)injector.getInstance(SessionPropertyDefaults.class)).loadConfigurationManager();
            ((ResourceGroupManager)injector.getInstance(ResourceGroupManager.class)).loadConfigurationManager();
            ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl();
            ((PasswordAuthenticatorManager)injector.getInstance(PasswordAuthenticatorManager.class)).loadPasswordAuthenticator();
            ((EventListenerManager)injector.getInstance(EventListenerManager.class)).loadEventListeners();
            ((GroupProviderManager)injector.getInstance(GroupProviderManager.class)).loadConfiguredGroupProvider();
            ((Announcer)injector.getInstance(Announcer.class)).start();
            ((ServerInfoResource)injector.getInstance(ServerInfoResource.class)).startupComplete();
            log.info("======== SERVER STARTED ========");
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    private static void updateConnectorIds(Announcer announcer, CatalogManager metadata, ServerConfig serverConfig, NodeSchedulerConfig schedulerConfig) {
        ServiceAnnouncement announcement = PrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        Set connectorIds = (Set)metadata.getCatalogs().stream().map(Catalog::getConnectorCatalogName).map(Object::toString).collect(ImmutableSet.toImmutableSet());
        ServiceAnnouncement.ServiceAnnouncementBuilder builder = ServiceAnnouncement.serviceAnnouncement((String)announcement.getType());
        builder.addProperties(announcement.getProperties());
        builder.addProperty("connectorIds", Joiner.on((char)',').join((Iterable)connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(builder.build());
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new IllegalArgumentException("Presto announcement not found: " + announcements);
    }

    private static void logLocation(Logger log, String name, Path path) {
        if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            log.info("%s: [does not exist]", new Object[]{name});
            return;
        }
        try {
            path = path.toAbsolutePath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            log.info("%s: [not accessible]", new Object[]{name});
            return;
        }
        log.info("%s: %s", new Object[]{name, path});
    }
}

