/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.client.ClientTypeSignature;
import io.prestosql.client.ClientTypeSignatureParameter;
import io.prestosql.client.Column;
import io.prestosql.client.FailureInfo;
import io.prestosql.client.NamedClientTypeSignature;
import io.prestosql.client.QueryError;
import io.prestosql.client.QueryResults;
import io.prestosql.client.RowFieldName;
import io.prestosql.client.StatementStats;
import io.prestosql.client.Warning;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStats;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.StageStats;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.operator.ExchangeClient;
import io.prestosql.server.protocol.RowIterable;
import io.prestosql.server.protocol.Slug;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoWarning;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.WarningCode;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.transaction.TransactionId;
import io.prestosql.util.Failures;
import io.prestosql.util.MoreLists;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@ThreadSafe
class Query {
    private static final Logger log = Logger.get(Query.class);
    private final QueryManager queryManager;
    private final QueryId queryId;
    private final Session session;
    private final Slug slug;
    @GuardedBy(value="this")
    private final ExchangeClient exchangeClient;
    private final Executor resultsProcessorExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final PagesSerde serde;
    @GuardedBy(value="this")
    private OptionalLong nextToken = OptionalLong.of(0L);
    @GuardedBy(value="this")
    private QueryResults lastResult;
    @GuardedBy(value="this")
    private long lastToken = -1L;
    @GuardedBy(value="this")
    private List<Column> columns;
    @GuardedBy(value="this")
    private List<Type> types;
    @GuardedBy(value="this")
    private Optional<String> setCatalog = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setSchema = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setPath = Optional.empty();
    @GuardedBy(value="this")
    private Map<String, String> setSessionProperties = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> resetSessionProperties = ImmutableSet.of();
    @GuardedBy(value="this")
    private Map<String, SelectedRole> setRoles = ImmutableMap.of();
    @GuardedBy(value="this")
    private Map<String, String> addedPreparedStatements = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> deallocatedPreparedStatements = ImmutableSet.of();
    @GuardedBy(value="this")
    private Optional<TransactionId> startedTransactionId = Optional.empty();
    @GuardedBy(value="this")
    private boolean clearTransactionId;
    @GuardedBy(value="this")
    private Long updateCount;

    public static Query create(Session session, Slug slug, QueryManager queryManager, ExchangeClient exchangeClient, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Query result = new Query(session, slug, queryManager, exchangeClient, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde);
        result.queryManager.addOutputInfoListener(result.getQueryId(), result::setQueryOutputInfo);
        result.queryManager.addStateChangeListener(result.getQueryId(), state -> {
            if (state.isDone()) {
                QueryInfo queryInfo = queryManager.getFullQueryInfo(result.getQueryId());
                result.closeExchangeClientIfNecessary(queryInfo);
            }
        });
        return result;
    }

    private Query(Session session, Slug slug, QueryManager queryManager, ExchangeClient exchangeClient, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(slug, "slug is null");
        Objects.requireNonNull(queryManager, "queryManager is null");
        Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        Objects.requireNonNull(blockEncodingSerde, "serde is null");
        this.queryManager = queryManager;
        this.queryId = session.getQueryId();
        this.session = session;
        this.slug = slug;
        this.exchangeClient = exchangeClient;
        this.resultsProcessorExecutor = resultsProcessorExecutor;
        this.timeoutExecutor = timeoutExecutor;
        this.serde = new PagesSerdeFactory(blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session)).createPagesSerde();
    }

    public void cancel() {
        this.queryManager.cancelQuery(this.queryId);
        this.dispose();
    }

    public void partialCancel(int id) {
        StageId stageId = new StageId(this.queryId, id);
        this.queryManager.cancelStage(stageId);
    }

    public void fail(Throwable throwable) {
        this.queryManager.failQuery(this.queryId, throwable);
    }

    public synchronized void dispose() {
        this.exchangeClient.close();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isSlugValid(String slug, long token) {
        return this.slug.isValid(Slug.Context.EXECUTING_QUERY, slug, token);
    }

    public QueryInfo getQueryInfo() {
        return this.queryManager.getFullQueryInfo(this.queryId);
    }

    public synchronized Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    public synchronized Optional<String> getSetSchema() {
        return this.setSchema;
    }

    public synchronized Optional<String> getSetPath() {
        return this.setPath;
    }

    public synchronized Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public synchronized Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public synchronized Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    public synchronized Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public synchronized Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public synchronized Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    public synchronized boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    public synchronized ListenableFuture<QueryResults> waitForResults(long token, UriInfo uriInfo, String scheme, Duration wait, DataSize targetResultSize) {
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return Futures.immediateFuture((Object)cachedResult.get());
        }
        ListenableFuture futureStateChange = MoreFutures.addTimeout(this.getFutureStateChange(), () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
        return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResult(token, uriInfo, scheme, targetResultSize), (Executor)this.resultsProcessorExecutor);
    }

    private synchronized ListenableFuture<?> getFutureStateChange() {
        if (!this.exchangeClient.isClosed()) {
            return this.exchangeClient.isBlocked();
        }
        this.queryManager.recordHeartbeat(this.queryId);
        try {
            return this.queryDoneFuture(this.queryManager.getQueryState(this.queryId));
        }
        catch (NoSuchElementException e) {
            return Futures.immediateFuture(null);
        }
    }

    private synchronized Optional<QueryResults> getCachedResult(long token) {
        if (this.lastResult == null) {
            return Optional.empty();
        }
        if (token == this.lastToken) {
            this.queryManager.recordHeartbeat(this.queryId);
            return Optional.of(this.lastResult);
        }
        if (token < this.lastToken) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        if (!this.nextToken.isPresent()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (token != this.nextToken.getAsLong()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Optional.empty();
    }

    private synchronized QueryResults getNextResult(long token, UriInfo uriInfo, String scheme, DataSize targetResultSize) {
        Number number;
        Iterator iterator;
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return cachedResult.get();
        }
        Verify.verify((boolean)this.nextToken.isPresent(), (String)"Cannot generate next result when next token is not present", (Object[])new Object[0]);
        Verify.verify((token == this.nextToken.getAsLong() ? 1 : 0) != 0, (String)"Expected token to equal next token", (Object[])new Object[0]);
        URI queryHtmlUri = uriInfo.getRequestUriBuilder().scheme(scheme).replacePath("ui/query.html").replaceQuery(this.queryId.toString()).build(new Object[0]);
        Iterable data = null;
        try {
            SerializedPage serializedPage;
            ImmutableList.Builder pages = ImmutableList.builder();
            long bytes = 0L;
            long rows = 0L;
            long targetResultBytes = targetResultSize.toBytes();
            while (bytes < targetResultBytes && (serializedPage = this.exchangeClient.pollPage()) != null) {
                Page page = this.serde.deserialize(serializedPage);
                bytes += page.getLogicalSizeInBytes();
                rows += (long)page.getPositionCount();
                pages.add((Object)new RowIterable(this.session.toConnectorSession(), this.types, page));
            }
            if (rows > 0L) {
                data = Iterables.concat((Iterable)pages.build());
            }
        }
        catch (Throwable cause) {
            this.queryManager.failQuery(this.queryId, cause);
        }
        QueryInfo queryInfo = this.queryManager.getFullQueryInfo(this.queryId);
        this.queryManager.recordHeartbeat(this.queryId);
        if (data != null && queryInfo.getUpdateType() != null && this.updateCount == null && this.columns.size() == 1 && this.columns.get(0).getType().equals("bigint") && (iterator = data.iterator()).hasNext() && (number = (Number)((List)iterator.next()).get(0)) != null) {
            this.updateCount = number.longValue();
        }
        this.closeExchangeClientIfNecessary(queryInfo);
        if (queryInfo.getState() == QueryState.FINISHED && !queryInfo.getOutputStage().isPresent()) {
            this.columns = ImmutableList.of((Object)Query.createColumn("result", (Type)BooleanType.BOOLEAN));
            data = ImmutableSet.of((Object)ImmutableList.of((Object)true));
        }
        this.nextToken = !queryInfo.isFinalQueryInfo() && queryInfo.getState() != QueryState.FAILED || !this.exchangeClient.isClosed() ? OptionalLong.of(token + 1L) : OptionalLong.empty();
        URI nextResultsUri = null;
        URI partialCancelUri = null;
        if (this.nextToken.isPresent()) {
            nextResultsUri = this.createNextResultsUri(scheme, uriInfo, this.nextToken.getAsLong());
            partialCancelUri = Query.findCancelableLeafStage(queryInfo).map(stage -> this.createPartialCancelUri((int)stage, scheme, uriInfo, this.nextToken.getAsLong())).orElse(null);
        }
        this.setCatalog = queryInfo.getSetCatalog();
        this.setSchema = queryInfo.getSetSchema();
        this.setPath = queryInfo.getSetPath();
        this.setSessionProperties = queryInfo.getSetSessionProperties();
        this.resetSessionProperties = queryInfo.getResetSessionProperties();
        this.setRoles = queryInfo.getSetRoles();
        this.addedPreparedStatements = queryInfo.getAddedPreparedStatements();
        this.deallocatedPreparedStatements = queryInfo.getDeallocatedPreparedStatements();
        this.startedTransactionId = queryInfo.getStartedTransactionId();
        this.clearTransactionId = queryInfo.isClearTransactionId();
        QueryResults queryResults = new QueryResults(this.queryId.toString(), queryHtmlUri, partialCancelUri, nextResultsUri, this.columns, data, Query.toStatementStats(queryInfo), Query.toQueryError(queryInfo), MoreLists.mappedCopy(queryInfo.getWarnings(), Query::toClientWarning), queryInfo.getUpdateType(), this.updateCount);
        this.lastToken = token;
        this.lastResult = queryResults;
        return queryResults;
    }

    private synchronized void closeExchangeClientIfNecessary(QueryInfo queryInfo) {
        if (queryInfo.getState() == QueryState.FAILED || queryInfo.getState().isDone() && !queryInfo.getOutputStage().isPresent()) {
            this.exchangeClient.close();
        }
    }

    private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
        if (this.columns == null) {
            List<String> columnNames = outputInfo.getColumnNames();
            List<Type> columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                list.add((Object)Query.createColumn(columnNames.get(i), columnTypes.get(i)));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
        }
        for (URI outputLocation : outputInfo.getBufferLocations()) {
            this.exchangeClient.addLocation(outputLocation);
        }
        if (outputInfo.isNoMoreBufferLocations()) {
            this.exchangeClient.noMoreLocations();
        }
    }

    private ListenableFuture<?> queryDoneFuture(QueryState currentState) {
        if (currentState.isDone()) {
            return Futures.immediateFuture(null);
        }
        return Futures.transformAsync(this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized URI createNextResultsUri(String scheme, UriInfo uriInfo, long nextToken) {
        return uriInfo.getBaseUriBuilder().scheme(scheme).replacePath("/v1/statement/executing").path(this.queryId.toString()).path(this.slug.makeSlug(Slug.Context.EXECUTING_QUERY, nextToken)).path(String.valueOf(nextToken)).replaceQuery("").build(new Object[0]);
    }

    private URI createPartialCancelUri(int stage, String scheme, UriInfo uriInfo, long nextToken) {
        return uriInfo.getBaseUriBuilder().scheme(scheme).replacePath("/v1/statement/executing/partialCancel").path(this.queryId.toString()).path(String.valueOf(stage)).path(this.slug.makeSlug(Slug.Context.EXECUTING_QUERY, nextToken)).path(String.valueOf(nextToken)).replaceQuery("").build(new Object[0]);
    }

    private static Column createColumn(String name, Type type) {
        TypeSignature signature = type.getTypeSignature();
        return new Column(name, type.getDisplayName(), Query.toClientTypeSignature(signature));
    }

    private static ClientTypeSignature toClientTypeSignature(TypeSignature signature) {
        return new ClientTypeSignature(signature.getBase(), (List)signature.getParameters().stream().map(Query::toClientTypeSignatureParameter).collect(ImmutableList.toImmutableList()));
    }

    private static ClientTypeSignatureParameter toClientTypeSignatureParameter(TypeSignatureParameter parameter) {
        switch (parameter.getKind()) {
            case TYPE: {
                return ClientTypeSignatureParameter.ofType((ClientTypeSignature)Query.toClientTypeSignature(parameter.getTypeSignature()));
            }
            case NAMED_TYPE: {
                return ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(parameter.getNamedTypeSignature().getFieldName().map(value -> new RowFieldName(value.getName())), Query.toClientTypeSignature(parameter.getNamedTypeSignature().getTypeSignature())));
            }
            case LONG: {
                return ClientTypeSignatureParameter.ofLong((long)parameter.getLongLiteral());
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + parameter.getKind());
    }

    private static StatementStats toStatementStats(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        StageInfo outputStage = queryInfo.getOutputStage().orElse(null);
        return StatementStats.builder().setState(queryInfo.getState().toString()).setQueued(queryInfo.getState() == QueryState.QUEUED).setScheduled(queryInfo.isScheduled()).setNodes(Query.globalUniqueNodes(outputStage).size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers() + queryStats.getBlockedDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setQueuedTimeMillis(queryStats.getQueuedTime().toMillis()).setElapsedTimeMillis(queryStats.getElapsedTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setPeakMemoryBytes(queryStats.getPeakUserMemoryReservation().toBytes()).setSpilledBytes(queryStats.getSpilledDataSize().toBytes()).setRootStage(Query.toStageStats(outputStage)).build();
    }

    private static io.prestosql.client.StageStats toStageStats(StageInfo stageInfo) {
        if (stageInfo == null) {
            return null;
        }
        StageStats stageStats = stageInfo.getStageStats();
        ImmutableList.Builder subStages = ImmutableList.builder();
        for (StageInfo subStage : stageInfo.getSubStages()) {
            subStages.add((Object)Query.toStageStats(subStage));
        }
        HashSet<String> uniqueNodes = new HashSet<String>();
        for (TaskInfo task : stageInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            uniqueNodes.add(uri.getHost() + ":" + uri.getPort());
        }
        return io.prestosql.client.StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(stageInfo.getState().toString()).setDone(stageInfo.getState().isDone()).setNodes(uniqueNodes.size()).setTotalSplits(stageStats.getTotalDrivers()).setQueuedSplits(stageStats.getQueuedDrivers()).setRunningSplits(stageStats.getRunningDrivers() + stageStats.getBlockedDrivers()).setCompletedSplits(stageStats.getCompletedDrivers()).setCpuTimeMillis(stageStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageStats.getRawInputPositions()).setProcessedBytes(stageStats.getRawInputDataSize().toBytes()).setSubStages((List)subStages.build()).build();
    }

    private static Set<String> globalUniqueNodes(StageInfo stageInfo) {
        if (stageInfo == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        for (TaskInfo task : stageInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            nodes.add((Object)(uri.getHost() + ":" + uri.getPort()));
        }
        for (StageInfo subStage : stageInfo.getSubStages()) {
            nodes.addAll(Query.globalUniqueNodes(subStage));
        }
        return nodes.build();
    }

    private static Optional<Integer> findCancelableLeafStage(QueryInfo queryInfo) {
        return queryInfo.getOutputStage().flatMap(Query::findCancelableLeafStage);
    }

    private static Optional<Integer> findCancelableLeafStage(StageInfo stage) {
        if (stage.getState().isDone()) {
            return Optional.empty();
        }
        for (StageInfo subStage : Lists.reverse(stage.getSubStages())) {
            Optional<Integer> leafStage = Query.findCancelableLeafStage(subStage);
            if (!leafStage.isPresent()) continue;
            return leafStage;
        }
        return Optional.of(stage.getStageId().getId());
    }

    private static QueryError toQueryError(QueryInfo queryInfo) {
        ErrorCode errorCode;
        ExecutionFailureInfo executionFailure;
        QueryState state = queryInfo.getState();
        if (state != QueryState.FAILED) {
            return null;
        }
        if (queryInfo.getFailureInfo() != null) {
            executionFailure = queryInfo.getFailureInfo();
        } else {
            log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
            executionFailure = Failures.toFailure(new RuntimeException(String.format("Query is %s (reason unknown)", new Object[]{state})));
        }
        FailureInfo failure = executionFailure.toFailureInfo();
        if (queryInfo.getErrorCode() != null) {
            errorCode = queryInfo.getErrorCode();
        } else {
            errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
            log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
        }
        return new QueryError((String)MoreObjects.firstNonNull((Object)failure.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), failure.getErrorLocation(), failure);
    }

    private static Warning toClientWarning(PrestoWarning warning) {
        WarningCode code = warning.getWarningCode();
        return new Warning(new Warning.Code(code.getCode(), code.getName()), warning.getMessage());
    }
}

