/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"http.server.authentication.enabled"})
public class SecurityConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<String> authenticationTypes = ImmutableList.of();
    private boolean enableForwardingHttps;

    @NotNull
    public List<String> getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    public SecurityConfig setAuthenticationTypes(List<String> authenticationTypes) {
        this.authenticationTypes = ImmutableList.copyOf(authenticationTypes);
        return this;
    }

    @Config(value="http-server.authentication.type")
    @ConfigDescription(value="Ordered list of authentication types")
    public SecurityConfig setAuthenticationTypes(String types) {
        this.authenticationTypes = Optional.ofNullable(types).map(arg_0 -> ((Splitter)SPLITTER).splitToList(arg_0)).orElse(null);
        return this;
    }

    public boolean getEnableForwardingHttps() {
        return this.enableForwardingHttps;
    }

    @Config(value="http-server.authentication.allow-forwarded-https")
    @ConfigDescription(value="Enable forwarding HTTPS requests")
    public SecurityConfig setEnableForwardingHttps(boolean enableForwardingHttps) {
        this.enableForwardingHttps = enableForwardingHttps;
        return this;
    }
}

