/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.ExpressionTreeUtils;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.FieldId;
import io.prestosql.sql.analyzer.FreeLambdaReferenceExtractor;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.analyzer.ScopeReferenceExtractor;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BindExpression;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.CurrentTime;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.FieldReference;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.WhenClause;
import io.prestosql.sql.tree.Window;
import io.prestosql.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

class AggregationAnalyzer {
    private final Set<FieldId> groupingFields;
    private final List<Expression> expressions;
    private final Map<NodeRef<Expression>, FieldId> columnReferences;
    private final Metadata metadata;
    private final Analysis analysis;
    private final Scope sourceScope;
    private final Optional<Scope> orderByScope;

    public static void verifySourceAggregations(List<Expression> groupByExpressions, Scope sourceScope, Expression expression, Metadata metadata, Analysis analysis) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.empty(), metadata, analysis);
        analyzer.analyze(expression);
    }

    public static void verifyOrderByAggregations(List<Expression> groupByExpressions, Scope sourceScope, Scope orderByScope, Expression expression, Metadata metadata, Analysis analysis) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.of(orderByScope), metadata, analysis);
        analyzer.analyze(expression);
    }

    private AggregationAnalyzer(List<Expression> groupByExpressions, Scope sourceScope, Optional<Scope> orderByScope, Metadata metadata, Analysis analysis) {
        Objects.requireNonNull(groupByExpressions, "groupByExpressions is null");
        Objects.requireNonNull(sourceScope, "sourceScope is null");
        Objects.requireNonNull(orderByScope, "orderByScope is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(analysis, "analysis is null");
        this.sourceScope = sourceScope;
        this.orderByScope = orderByScope;
        this.metadata = metadata;
        this.analysis = analysis;
        this.expressions = groupByExpressions;
        this.columnReferences = analysis.getColumnReferenceFields();
        this.groupingFields = (Set)groupByExpressions.stream().map(NodeRef::of).filter(this.columnReferences::containsKey).map(this.columnReferences::get).collect(ImmutableSet.toImmutableSet());
        this.groupingFields.forEach(fieldId -> Preconditions.checkState((boolean)ScopeReferenceExtractor.isFieldFromScope(fieldId, sourceScope), (String)"Grouping field %s should originate from %s", (Object)fieldId, (Object)sourceScope.getRelationType()));
    }

    private void analyze(Expression expression) {
        Visitor visitor = new Visitor();
        if (!visitor.process((Node)expression, null).booleanValue()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "'%s' must be an aggregate expression or appear in GROUP BY clause", expression);
        }
    }

    private boolean hasOrderByReferencesToOutputColumns(Node node) {
        return ScopeReferenceExtractor.hasReferencesToScope(node, this.analysis, this.orderByScope.get());
    }

    private void verifyNoOrderByReferencesToOutputColumns(Node node, StandardErrorCode errorCode, String errorString) {
        ScopeReferenceExtractor.getReferencesToScope(node, this.analysis, this.orderByScope.get()).findFirst().ifPresent(expression -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)errorCode, (Node)expression, errorString, new Object[0]);
        });
    }

    private class Visitor
    extends AstVisitor<Boolean, Void> {
        private Visitor() {
        }

        protected Boolean visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("aggregation analysis not yet implemented for: " + node.getClass().getName());
        }

        protected Boolean visitAtTimeZone(AtTimeZone node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitSubqueryExpression(SubqueryExpression node, Void context) {
            ScopeReferenceExtractor.getReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope).filter(expression -> !this.isGroupingKey((Expression)expression)).findFirst().ifPresent(expression -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "Subquery uses '%s' which must appear in GROUP BY clause", expression);
            });
            return true;
        }

        protected Boolean visitExists(ExistsPredicate node, Void context) {
            Preconditions.checkState((boolean)(node.getSubquery() instanceof SubqueryExpression));
            return this.process((Node)node.getSubquery(), context);
        }

        protected Boolean visitSubscriptExpression(SubscriptExpression node, Void context) {
            return this.process((Node)node.getBase(), context) != false && this.process((Node)node.getIndex(), context) != false;
        }

        protected Boolean visitArrayConstructor(ArrayConstructor node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitCast(Cast node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
            return node.getOperands().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
            return this.process((Node)node.getFirst(), context) != false && this.process((Node)node.getSecond(), context) != false;
        }

        protected Boolean visitExtract(Extract node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
            return this.process((Node)node.getMin(), context) != false && this.process((Node)node.getValue(), context) != false && this.process((Node)node.getMax(), context) != false;
        }

        protected Boolean visitCurrentTime(CurrentTime node, Void context) {
            return true;
        }

        protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitLiteral(Literal node, Void context) {
            return true;
        }

        protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLikePredicate(LikePredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getPattern(), context) != false;
        }

        protected Boolean visitInListExpression(InListExpression node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitInPredicate(InPredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getValueList(), context) != false;
        }

        protected Boolean visitFunctionCall(FunctionCall node, Void context) {
            if (AggregationAnalyzer.this.metadata.isAggregationFunction(node.getName())) {
                if (!node.getWindow().isPresent()) {
                    List<FunctionCall> aggregateFunctions = ExpressionTreeUtils.extractAggregateFunctions(node.getArguments(), AggregationAnalyzer.this.metadata);
                    List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions(node.getArguments());
                    if (!aggregateFunctions.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_AGGREGATION, (Node)node, "Cannot nest aggregations inside aggregation '%s': %s", node.getName(), aggregateFunctions);
                    }
                    if (!windowFunctions.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside aggregation '%s': %s", node.getName(), windowFunctions);
                    }
                    if (node.getOrderBy().isPresent()) {
                        List sortKeys = (List)((OrderBy)node.getOrderBy().get()).getSortItems().stream().map(SortItem::getSortKey).collect(ImmutableList.toImmutableList());
                        if (node.isDistinct()) {
                            List fieldIds = (List)node.getArguments().stream().map(NodeRef::of).map(AggregationAnalyzer.this.columnReferences::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                            for (Expression sortKey : sortKeys) {
                                if (node.getArguments().contains(sortKey) || fieldIds.contains(AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)sortKey)))) continue;
                                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT, (Node)sortKey, "For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments", new Object[0]);
                            }
                        }
                        if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                            for (Expression sortKey : sortKeys) {
                                AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)sortKey, StandardErrorCode.COLUMN_NOT_FOUND, "ORDER BY clause in aggregation function must not reference query output columns");
                            }
                        }
                    }
                    if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                        node.getArguments().stream().forEach(argument -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)argument, StandardErrorCode.COLUMN_NOT_FOUND, "Invalid reference to output projection attribute from ORDER BY aggregation"));
                    }
                    return true;
                }
            } else {
                if (node.getFilter().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE, (Node)node, "Filter is only valid for aggregation functions", node);
                }
                if (node.getOrderBy().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE, (Node)node, "ORDER BY is only valid for aggregation functions", new Object[0]);
                }
            }
            if (node.getWindow().isPresent() && !this.process((Node)node.getWindow().get(), context).booleanValue()) {
                return false;
            }
            return node.getArguments().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitLambdaExpression(LambdaExpression node, Void context) {
            return this.process((Node)node.getBody(), context);
        }

        protected Boolean visitBindExpression(BindExpression node, Void context) {
            for (Expression value : node.getValues()) {
                if (this.process((Node)value, context).booleanValue()) continue;
                return false;
            }
            return this.process((Node)node.getFunction(), context);
        }

        protected Boolean visitWindow(Window node, Void context) {
            for (Expression expression : node.getPartitionBy()) {
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "PARTITION BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(node.getOrderBy())) {
                Expression expression = sortItem.getSortKey();
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "ORDER BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            if (node.getFrame().isPresent()) {
                this.process((Node)node.getFrame().get(), context);
            }
            return true;
        }

        protected Boolean visitWindowFrame(WindowFrame node, Void context) {
            Expression endValue;
            Optional start = node.getStart().getValue();
            if (start.isPresent() && !this.process((Node)start.get(), context).booleanValue()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)start.get(), "Window frame start must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            if (node.getEnd().isPresent() && ((FrameBound)node.getEnd().get()).getValue().isPresent() && !this.process((Node)(endValue = (Expression)((FrameBound)node.getEnd().get()).getValue().get()), context).booleanValue()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)endValue, "Window frame end must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            return true;
        }

        protected Boolean visitIdentifier(Identifier node, Void context) {
            if (AggregationAnalyzer.this.analysis.getLambdaArgumentReferences().containsKey(NodeRef.of((Node)node))) {
                return true;
            }
            if (!ScopeReferenceExtractor.hasReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) {
                return true;
            }
            return this.isGroupingKey((Expression)node);
        }

        protected Boolean visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (!ScopeReferenceExtractor.hasReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) {
                return true;
            }
            if (AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)node))) {
                return this.isGroupingKey((Expression)node);
            }
            return this.process((Node)node.getBase(), context);
        }

        private boolean isGroupingKey(Expression node) {
            FieldId fieldId = (FieldId)AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)node));
            Objects.requireNonNull(fieldId, () -> "No FieldId for " + node);
            if (AggregationAnalyzer.this.orderByScope.isPresent() && ScopeReferenceExtractor.isFieldFromScope(fieldId, (Scope)AggregationAnalyzer.this.orderByScope.get())) {
                return true;
            }
            return AggregationAnalyzer.this.groupingFields.contains(fieldId);
        }

        protected Boolean visitFieldReference(FieldReference node, Void context) {
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                return true;
            }
            FieldId fieldId = (FieldId)Objects.requireNonNull(AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)node)), "No FieldId for FieldReference");
            boolean inGroup = AggregationAnalyzer.this.groupingFields.contains(fieldId);
            if (!inGroup) {
                Field field = AggregationAnalyzer.this.sourceScope.getRelationType().getFieldByIndex(node.getFieldIndex());
                String column = !field.getName().isPresent() ? Integer.toString(node.getFieldIndex() + 1) : (field.getRelationAlias().isPresent() ? String.format("'%s.%s'", field.getRelationAlias().get(), field.getName().get()) : "'" + field.getName().get() + "'");
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)node, "Column %s not in GROUP BY clause", column);
            }
            return inGroup;
        }

        protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitNotExpression(NotExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder expressions = ImmutableList.builder().add((Object)node.getCondition()).add((Object)node.getTrueValue());
            if (node.getFalseValue().isPresent()) {
                expressions.add(node.getFalseValue().get());
            }
            return expressions.build().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            if (!this.process((Node)node.getOperand(), context).booleanValue()) {
                return false;
            }
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            if (node.getDefaultValue().isPresent() && !this.process((Node)node.getDefaultValue().get(), context).booleanValue()) {
                return false;
            }
            return true;
        }

        protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return !node.getDefaultValue().isPresent() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        protected Boolean visitTryExpression(TryExpression node, Void context) {
            return this.process((Node)node.getInnerExpression(), context);
        }

        protected Boolean visitRow(Row node, Void context) {
            return node.getItems().stream().allMatch(item -> this.process((Node)item, context));
        }

        protected Boolean visitParameter(Parameter node, Void context) {
            if (AggregationAnalyzer.this.analysis.isDescribe()) {
                return true;
            }
            Map<NodeRef<Parameter>, Expression> parameters = AggregationAnalyzer.this.analysis.getParameters();
            Preconditions.checkArgument((node.getPosition() < parameters.size() ? 1 : 0) != 0, (String)"Invalid parameter number %s, max values is %s", (int)node.getPosition(), (int)(parameters.size() - 1));
            return this.process((Node)parameters.get(NodeRef.of((Node)node)), context);
        }

        protected Boolean visitGroupingOperation(GroupingOperation node, Void context) {
            Optional<Expression> argumentNotInGroupBy;
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                node.getGroupingColumns().forEach(groupingColumn -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)groupingColumn, StandardErrorCode.INVALID_ARGUMENTS, "Invalid reference to output of SELECT clause from grouping() expression in ORDER BY"));
            }
            if ((argumentNotInGroupBy = node.getGroupingColumns().stream().filter(argument -> !AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)argument)) || !this.isGroupingKey((Expression)argument)).findAny()).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "The arguments to GROUPING() must be expressions referenced by the GROUP BY at the associated query level. Mismatch due to %s.", argumentNotInGroupBy.get());
            }
            return true;
        }

        public Boolean process(Node node, @Nullable Void context) {
            if (!(!AggregationAnalyzer.this.expressions.stream().anyMatch(arg_0 -> ((Node)node).equals(arg_0)) || AggregationAnalyzer.this.orderByScope.isPresent() && AggregationAnalyzer.this.hasOrderByReferencesToOutputColumns(node) || FreeLambdaReferenceExtractor.hasFreeReferencesToLambdaArgument(node, AggregationAnalyzer.this.analysis))) {
                return true;
            }
            return (Boolean)super.process(node, (Object)context);
        }
    }
}

