/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import io.prestosql.metadata.NewTableLayout;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.eventlistener.ColumnInfo;
import io.prestosql.spi.eventlistener.RoutineInfo;
import io.prestosql.spi.eventlistener.TableInfo;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.ExpressionAnalysis;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.FieldId;
import io.prestosql.sql.analyzer.Output;
import io.prestosql.sql.analyzer.RelationType;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.Join;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.Offset;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.QuerySpecification;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.SampledRelation;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.Table;
import io.prestosql.transaction.TransactionId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    @Nullable
    private final Statement root;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private String updateType;
    private Optional<QualifiedObjectName> target = Optional.empty();
    private final Map<NodeRef<Table>, Query> namedQueries = new LinkedHashMap<NodeRef<Table>, Query>();
    private final Map<NodeRef<Node>, Scope> scopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Map<NodeRef<Expression>, FieldId> columnReferences = new LinkedHashMap<NodeRef<Expression>, FieldId>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> tableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<String>>>();
    private final Multimap<NodeRef<? extends Node>, Field> referencedFields = HashMultimap.create();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> aggregates = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<Expression>> orderByAggregates = new LinkedHashMap<NodeRef<OrderBy>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, List<Expression>> groupByExpressions = new LinkedHashMap<NodeRef<QuerySpecification>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, GroupingSetAnalysis> groupingSets = new LinkedHashMap<NodeRef<QuerySpecification>, GroupingSetAnalysis>();
    private final Map<NodeRef<Node>, Expression> where = new LinkedHashMap<NodeRef<Node>, Expression>();
    private final Map<NodeRef<QuerySpecification>, Expression> having = new LinkedHashMap<NodeRef<QuerySpecification>, Expression>();
    private final Map<NodeRef<Node>, List<Expression>> orderByExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Set<NodeRef<OrderBy>> redundantOrderBy = new HashSet<NodeRef<OrderBy>>();
    private final Map<NodeRef<Node>, List<SelectExpression>> selectExpressions = new LinkedHashMap<NodeRef<Node>, List<SelectExpression>>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> windowFunctions = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<FunctionCall>> orderByWindowFunctions = new LinkedHashMap<NodeRef<OrderBy>, List<FunctionCall>>();
    private final Map<NodeRef<Offset>, Long> offset = new LinkedHashMap<NodeRef<Offset>, Long>();
    private final Map<NodeRef<Node>, OptionalLong> limit = new LinkedHashMap<NodeRef<Node>, OptionalLong>();
    private final Map<NodeRef<AllColumns>, List<Field>> selectAllResultFields = new LinkedHashMap<NodeRef<AllColumns>, List<Field>>();
    private final Map<NodeRef<Join>, Expression> joins = new LinkedHashMap<NodeRef<Join>, Expression>();
    private final Map<NodeRef<Join>, JoinUsingAnalysis> joinUsing = new LinkedHashMap<NodeRef<Join>, JoinUsingAnalysis>();
    private final ListMultimap<NodeRef<Node>, InPredicate> inPredicatesSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, SubqueryExpression> scalarSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, ExistsPredicate> existsSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, QuantifiedComparisonExpression> quantifiedComparisonSubqueries = ArrayListMultimap.create();
    private final Map<NodeRef<Table>, TableEntry> tables = new LinkedHashMap<NodeRef<Table>, TableEntry>();
    private final Map<NodeRef<Expression>, Type> types = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> coercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Map<NodeRef<Relation>, List<Type>> relationCoercions = new LinkedHashMap<NodeRef<Relation>, List<Type>>();
    private final Map<NodeRef<FunctionCall>, RoutineEntry> resolvedFunctions = new LinkedHashMap<NodeRef<FunctionCall>, RoutineEntry>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Map<Field, ColumnHandle> columns = new LinkedHashMap<Field, ColumnHandle>();
    private final Map<NodeRef<SampledRelation>, Double> sampleRatios = new LinkedHashMap<NodeRef<SampledRelation>, Double>();
    private final Map<NodeRef<QuerySpecification>, List<GroupingOperation>> groupingOperations = new LinkedHashMap<NodeRef<QuerySpecification>, List<GroupingOperation>>();
    private final Multiset<RowFilterScopeEntry> rowFilterScopes = HashMultiset.create();
    private final Map<NodeRef<Table>, List<Expression>> rowFilters = new LinkedHashMap<NodeRef<Table>, List<Expression>>();
    private final Multiset<ColumnMaskScopeEntry> columnMaskScopes = HashMultiset.create();
    private final Map<NodeRef<Table>, Map<String, List<Expression>>> columnMasks = new LinkedHashMap<NodeRef<Table>, Map<String, List<Expression>>>();
    private Optional<Create> create = Optional.empty();
    private Optional<Insert> insert = Optional.empty();
    private Optional<TableHandle> analyzeTarget = Optional.empty();
    private final boolean isDescribe;
    private final Deque<Table> tablesForView = new ArrayDeque<Table>();

    public Analysis(@Nullable Statement root, Map<NodeRef<Parameter>, Expression> parameters, boolean isDescribe) {
        this.root = root;
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameterMap is null"));
        this.isDescribe = isDescribe;
    }

    public Statement getStatement() {
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public Optional<Output> getTarget() {
        return this.target.map(table -> new Output(table.getCatalogName(), table.getSchemaName(), table.getObjectName()));
    }

    public void setUpdateType(String updateType, QualifiedObjectName target) {
        this.updateType = updateType;
        this.target = Optional.of(target);
    }

    public void resetUpdateType() {
        this.updateType = null;
        this.target = Optional.empty();
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(aggregates));
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(NodeRef.of((Node)query));
    }

    public void setOrderByAggregates(OrderBy node, List<Expression> aggregates) {
        this.orderByAggregates.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(aggregates));
    }

    public List<Expression> getOrderByAggregates(OrderBy node) {
        return this.orderByAggregates.get(NodeRef.of((Node)node));
    }

    public Map<NodeRef<Expression>, Type> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public Type getType(Expression expression) {
        Type type = this.types.get(NodeRef.of((Node)expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression not analyzed: %s", (Object)expression);
        return type;
    }

    public Type getTypeWithCoercions(Expression expression) {
        NodeRef key = NodeRef.of((Node)expression);
        Preconditions.checkArgument((boolean)this.types.containsKey(key), (String)"Expression not analyzed: %s", (Object)expression);
        if (this.coercions.containsKey(key)) {
            return this.coercions.get(key);
        }
        return this.types.get(key);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return Optional.ofNullable(this.relationCoercions.get(NodeRef.of((Node)relation))).map(types -> (Type[])types.stream().toArray(Type[]::new)).orElse(null);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put((NodeRef<Relation>)NodeRef.of((Node)relation), (List<Type>)ImmutableList.copyOf((Object[])types));
    }

    public Map<NodeRef<Expression>, Type> getCoercions() {
        return Collections.unmodifiableMap(this.coercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(NodeRef.of((Node)expression));
    }

    public void addLambdaArgumentReferences(Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences) {
        this.lambdaArgumentReferences.putAll(lambdaArgumentReferences);
    }

    public LambdaArgumentDeclaration getLambdaArgumentReference(Identifier identifier) {
        return this.lambdaArgumentReferences.get(NodeRef.of((Node)identifier));
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public void setGroupingSets(QuerySpecification node, GroupingSetAnalysis groupingSets) {
        this.groupingSets.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), groupingSets);
    }

    public void setGroupByExpressions(QuerySpecification node, List<Expression> expressions) {
        this.groupByExpressions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expressions);
    }

    public boolean isAggregation(QuerySpecification node) {
        return this.groupByExpressions.containsKey(NodeRef.of((Node)node));
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(NodeRef.of((Node)expression));
    }

    public GroupingSetAnalysis getGroupingSets(QuerySpecification node) {
        return this.groupingSets.get(NodeRef.of((Node)node));
    }

    public List<Expression> getGroupByExpressions(QuerySpecification node) {
        return this.groupByExpressions.get(NodeRef.of((Node)node));
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put((NodeRef<Node>)NodeRef.of((Node)node), expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(NodeRef.of((Node)node));
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(items));
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(NodeRef.of((Node)node));
    }

    public void setOffset(Offset node, long rowCount) {
        this.offset.put((NodeRef<Offset>)NodeRef.of((Node)node), rowCount);
    }

    public long getOffset(Offset node) {
        Preconditions.checkState((boolean)this.offset.containsKey(NodeRef.of((Node)node)), (String)"missing OFFSET value for node %s", (Object)node);
        return this.offset.get(NodeRef.of((Node)node));
    }

    public void setLimit(Node node, OptionalLong rowCount) {
        this.limit.put((NodeRef<Node>)NodeRef.of((Node)node), rowCount);
    }

    public void setLimit(Node node, long rowCount) {
        this.limit.put((NodeRef<Node>)NodeRef.of((Node)node), OptionalLong.of(rowCount));
    }

    public OptionalLong getLimit(Node node) {
        Preconditions.checkState((boolean)this.limit.containsKey(NodeRef.of((Node)node)), (String)"missing LIMIT value for node %s", (Object)node);
        return this.limit.get(NodeRef.of((Node)node));
    }

    public void setSelectAllResultFields(AllColumns node, List<Field> expressions) {
        this.selectAllResultFields.put((NodeRef<AllColumns>)NodeRef.of((Node)node), (List<Field>)ImmutableList.copyOf(expressions));
    }

    public List<Field> getSelectAllResultFields(AllColumns node) {
        return this.selectAllResultFields.get(NodeRef.of((Node)node));
    }

    public void setSelectExpressions(Node node, List<SelectExpression> expressions) {
        this.selectExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<SelectExpression>)ImmutableList.copyOf(expressions));
    }

    public List<SelectExpression> getSelectExpressions(Node node) {
        return this.selectExpressions.get(NodeRef.of((Node)node));
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put((NodeRef<Join>)NodeRef.of((Node)node), criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(NodeRef.of((Node)join));
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        NodeRef key = NodeRef.of((Node)node);
        this.inPredicatesSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getSubqueryInPredicates()));
        this.scalarSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getScalarSubqueries()));
        this.existsSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getExistsSubqueries()));
        this.quantifiedComparisonSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getQuantifiedComparisons()));
    }

    private <T extends Node> List<T> dereference(Collection<NodeRef<T>> nodeRefs) {
        return (List)nodeRefs.stream().map(NodeRef::getNode).collect(ImmutableList.toImmutableList());
    }

    public List<InPredicate> getInPredicateSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.inPredicatesSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<SubqueryExpression> getScalarSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.scalarSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<ExistsPredicate> getExistsSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.existsSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<QuantifiedComparisonExpression> getQuantifiedComparisonSubqueries(Node node) {
        return Collections.unmodifiableList(this.quantifiedComparisonSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(NodeRef.of((Node)query));
    }

    public void setOrderByWindowFunctions(OrderBy node, List<FunctionCall> functions) {
        this.orderByWindowFunctions.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getOrderByWindowFunctions(OrderBy query) {
        return this.orderByWindowFunctions.get(NodeRef.of((Node)query));
    }

    public void addColumnReferences(Map<NodeRef<Expression>, FieldId> columnReferences) {
        this.columnReferences.putAll(columnReferences);
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public Optional<Scope> tryGetScope(Node node) {
        NodeRef key = NodeRef.of((Node)node);
        if (this.scopes.containsKey(key)) {
            return Optional.of(this.scopes.get(key));
        }
        return Optional.empty();
    }

    public Scope getRootScope() {
        return this.getScope((Node)this.root);
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put((NodeRef<Node>)NodeRef.of((Node)node), scope);
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor((Node)this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(NodeRef.of((Node)table)).getHandle().orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a table reference", table)));
    }

    public Collection<TableHandle> getTables() {
        return (Collection)this.tables.values().stream().map(TableEntry::getHandle).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    public void registerTable(Table table, Optional<TableHandle> handle, QualifiedObjectName name, List<ViewExpression> filters, Map<Field, List<ViewExpression>> columnMasks, String authorization) {
        this.tables.put((NodeRef<Table>)NodeRef.of((Node)table), new TableEntry(handle, name, filters, columnMasks, authorization));
    }

    public ResolvedFunction getResolvedFunction(FunctionCall function) {
        return this.resolvedFunctions.get(NodeRef.of((Node)function)).getFunction();
    }

    public void addResolvedFunction(FunctionCall node, ResolvedFunction function, String authorization) {
        this.resolvedFunctions.put((NodeRef<FunctionCall>)NodeRef.of((Node)node), new RoutineEntry(function, authorization));
    }

    public Set<NodeRef<Expression>> getColumnReferences() {
        return Collections.unmodifiableSet(this.columnReferences.keySet());
    }

    public Map<NodeRef<Expression>, FieldId> getColumnReferenceFields() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public boolean isColumnReference(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        Preconditions.checkArgument((this.getType(expression) != null ? 1 : 0) != 0, (String)"expression %s has not been analyzed", (Object)expression);
        return this.columnReferences.containsKey(NodeRef.of((Node)expression));
    }

    public void addTypes(Map<NodeRef<Expression>, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add((NodeRef<Expression>)NodeRef.of((Node)expression));
        }
    }

    public void addCoercions(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(NodeRef.of((Node)query));
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public Optional<TableHandle> getAnalyzeTarget() {
        return this.analyzeTarget;
    }

    public void setAnalyzeTarget(TableHandle analyzeTarget) {
        this.analyzeTarget = Optional.of(analyzeTarget);
    }

    public void setCreate(Create create) {
        this.create = Optional.of(create);
    }

    public Optional<Create> getCreate() {
        return this.create;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(NodeRef.of((Node)table));
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put((NodeRef<Table>)NodeRef.of((Node)tableReference), query);
    }

    public void registerTableForView(Table tableReference) {
        this.tablesForView.push(Objects.requireNonNull(tableReference, "table is null"));
    }

    public void unregisterTableForView() {
        this.tablesForView.pop();
    }

    public boolean hasTableInView(Table tableReference) {
        return this.tablesForView.contains(tableReference);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put((NodeRef<SampledRelation>)NodeRef.of((Node)relation), ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        NodeRef key = NodeRef.of((Node)relation);
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(key), (String)"Sample ratio missing for %s. Broken analysis?", (Object)relation);
        return this.sampleRatios.get(key);
    }

    public void setGroupingOperations(QuerySpecification querySpecification, List<GroupingOperation> groupingOperations) {
        this.groupingOperations.put((NodeRef<QuerySpecification>)NodeRef.of((Node)querySpecification), (List<GroupingOperation>)ImmutableList.copyOf(groupingOperations));
    }

    public List<GroupingOperation> getGroupingOperations(QuerySpecification querySpecification) {
        return Optional.ofNullable(this.groupingOperations.get(NodeRef.of((Node)querySpecification))).orElse(Collections.emptyList());
    }

    public Map<NodeRef<Parameter>, Expression> getParameters() {
        return this.parameters;
    }

    public boolean isDescribe() {
        return this.isDescribe;
    }

    public void setJoinUsing(Join node, JoinUsingAnalysis analysis) {
        this.joinUsing.put((NodeRef<Join>)NodeRef.of((Node)node), analysis);
    }

    public JoinUsingAnalysis getJoinUsing(Join node) {
        return this.joinUsing.get(NodeRef.of((Node)node));
    }

    public void addTableColumnReferences(AccessControl accessControl, Identity identity, Multimap<QualifiedObjectName, String> tableColumnMap) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        Map references = this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap());
        tableColumnMap.asMap().forEach((key, value) -> references.computeIfAbsent(key, k -> new HashSet()).addAll(value));
    }

    public void addEmptyColumnReferencesForTable(AccessControl accessControl, Identity identity, QualifiedObjectName table) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap()).computeIfAbsent(table, k -> new HashSet());
    }

    public void addReferencedFields(Multimap<NodeRef<Node>, Field> references) {
        this.referencedFields.putAll(references);
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public void markRedundantOrderBy(OrderBy orderBy) {
        this.redundantOrderBy.add((NodeRef<OrderBy>)NodeRef.of((Node)orderBy));
    }

    public boolean isOrderByRedundant(OrderBy orderBy) {
        return this.redundantOrderBy.contains(NodeRef.of((Node)orderBy));
    }

    public boolean hasRowFilter(QualifiedObjectName table, String identity) {
        return this.rowFilterScopes.contains((Object)new RowFilterScopeEntry(table, identity));
    }

    public void registerTableForRowFiltering(QualifiedObjectName table, String identity) {
        this.rowFilterScopes.add((Object)new RowFilterScopeEntry(table, identity));
    }

    public void unregisterTableForRowFiltering(QualifiedObjectName table, String identity) {
        this.rowFilterScopes.remove((Object)new RowFilterScopeEntry(table, identity));
    }

    public void addRowFilter(Table table, Expression filter) {
        this.rowFilters.computeIfAbsent((NodeRef<Table>)NodeRef.of((Node)table), node -> new ArrayList()).add(filter);
    }

    public List<Expression> getRowFilters(Table node) {
        return this.rowFilters.getOrDefault(NodeRef.of((Node)node), (List<Expression>)ImmutableList.of());
    }

    public boolean hasColumnMask(QualifiedObjectName table, String column, String identity) {
        return this.columnMaskScopes.contains((Object)new ColumnMaskScopeEntry(table, column, identity));
    }

    public void registerTableForColumnMasking(QualifiedObjectName table, String column, String identity) {
        this.columnMaskScopes.add((Object)new ColumnMaskScopeEntry(table, column, identity));
    }

    public void unregisterTableForColumnMasking(QualifiedObjectName table, String column, String identity) {
        this.columnMaskScopes.remove((Object)new ColumnMaskScopeEntry(table, column, identity));
    }

    public void addColumnMask(Table table, String column, Expression mask) {
        Map masks = this.columnMasks.computeIfAbsent((NodeRef<Table>)NodeRef.of((Node)table), node -> new LinkedHashMap());
        masks.computeIfAbsent(column, name -> new ArrayList()).add(mask);
    }

    public Map<String, List<Expression>> getColumnMasks(Table table) {
        return this.columnMasks.getOrDefault(NodeRef.of((Node)table), (Map<String, List<Expression>>)ImmutableMap.of());
    }

    public List<TableInfo> getReferencedTables() {
        return (List)this.tables.entrySet().stream().map(entry -> {
            NodeRef table = (NodeRef)entry.getKey();
            List columns = (List)this.referencedFields.get((Object)table).stream().map(field -> {
                String fieldName = field.getName().get();
                return new ColumnInfo(fieldName, (List)this.columnMasks.getOrDefault(table, (Map<String, List<Expression>>)ImmutableMap.of()).getOrDefault(fieldName, (List<Expression>)ImmutableList.of()).stream().map(Expression::toString).collect(ImmutableList.toImmutableList()));
            }).collect(ImmutableList.toImmutableList());
            TableEntry info = (TableEntry)entry.getValue();
            return new TableInfo(info.getName().getCatalogName(), info.getName().getSchemaName(), info.getName().getObjectName(), info.getAuthorization(), (List)this.rowFilters.getOrDefault(table, (List<Expression>)ImmutableList.of()).stream().map(Expression::toString).collect(ImmutableList.toImmutableList()), columns);
        }).collect(ImmutableList.toImmutableList());
    }

    public List<RoutineInfo> getRoutines() {
        return (List)this.resolvedFunctions.entrySet().stream().map(entry -> new RoutineInfo(((RoutineEntry)entry.getValue()).function.getSignature().getName(), ((RoutineEntry)entry.getValue()).getAuthorization())).collect(ImmutableList.toImmutableList());
    }

    private static class RoutineEntry {
        private final ResolvedFunction function;
        private final String authorization;

        public RoutineEntry(ResolvedFunction function, String authorization) {
            this.function = Objects.requireNonNull(function, "function is null");
            this.authorization = Objects.requireNonNull(authorization, "authorization is null");
        }

        public ResolvedFunction getFunction() {
            return this.function;
        }

        public String getAuthorization() {
            return this.authorization;
        }
    }

    private static class TableEntry {
        private final Optional<TableHandle> handle;
        private final QualifiedObjectName name;
        private final List<ViewExpression> filters;
        private final Map<Field, List<ViewExpression>> columnMasks;
        private final String authorization;

        public TableEntry(Optional<TableHandle> handle, QualifiedObjectName name, List<ViewExpression> filters, Map<Field, List<ViewExpression>> columnMasks, String authorization) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.filters = Objects.requireNonNull(filters, "filters is null");
            this.columnMasks = Objects.requireNonNull(columnMasks, "columnMasks is null");
            this.authorization = Objects.requireNonNull(authorization, "authorization is null");
        }

        public Optional<TableHandle> getHandle() {
            return this.handle;
        }

        public QualifiedObjectName getName() {
            return this.name;
        }

        public List<ViewExpression> getFilters() {
            return this.filters;
        }

        public Map<Field, List<ViewExpression>> getColumnMasks() {
            return this.columnMasks;
        }

        public String getAuthorization() {
            return this.authorization;
        }
    }

    private static class ColumnMaskScopeEntry {
        private final QualifiedObjectName table;
        private final String column;
        private final String identity;

        public ColumnMaskScopeEntry(QualifiedObjectName table, String column, String identity) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.column = Objects.requireNonNull(column, "column is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnMaskScopeEntry that = (ColumnMaskScopeEntry)o;
            return this.table.equals(that.table) && this.column.equals(that.column) && this.identity.equals(that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.column, this.identity);
        }
    }

    private static class RowFilterScopeEntry {
        private final QualifiedObjectName table;
        private final String identity;

        public RowFilterScopeEntry(QualifiedObjectName table, String identity) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowFilterScopeEntry that = (RowFilterScopeEntry)o;
            return this.table.equals(that.table) && this.identity.equals(that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.identity);
        }
    }

    public static final class AccessControlInfo {
        private final AccessControl accessControl;
        private final Identity identity;

        public AccessControlInfo(AccessControl accessControl, Identity identity) {
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public AccessControl getAccessControl() {
            return this.accessControl;
        }

        public SecurityContext getSecurityContext(TransactionId transactionId) {
            return new SecurityContext(transactionId, this.identity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessControlInfo that = (AccessControlInfo)o;
            return Objects.equals(this.accessControl, that.accessControl) && Objects.equals(this.identity, that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.accessControl, this.identity);
        }

        public String toString() {
            return String.format("AccessControl: %s, Identity: %s", this.accessControl.getClass(), this.identity);
        }
    }

    public static class GroupingSetAnalysis {
        private final List<Set<FieldId>> cubes;
        private final List<List<FieldId>> rollups;
        private final List<List<Set<FieldId>>> ordinarySets;
        private final List<Expression> complexExpressions;

        public GroupingSetAnalysis(List<Set<FieldId>> cubes, List<List<FieldId>> rollups, List<List<Set<FieldId>>> ordinarySets, List<Expression> complexExpressions) {
            this.cubes = ImmutableList.copyOf(cubes);
            this.rollups = ImmutableList.copyOf(rollups);
            this.ordinarySets = ImmutableList.copyOf(ordinarySets);
            this.complexExpressions = ImmutableList.copyOf(complexExpressions);
        }

        public List<Set<FieldId>> getCubes() {
            return this.cubes;
        }

        public List<List<FieldId>> getRollups() {
            return this.rollups;
        }

        public List<List<Set<FieldId>>> getOrdinarySets() {
            return this.ordinarySets;
        }

        public List<Expression> getComplexExpressions() {
            return this.complexExpressions;
        }
    }

    public static final class JoinUsingAnalysis {
        private final List<Integer> leftJoinFields;
        private final List<Integer> rightJoinFields;
        private final List<Integer> otherLeftFields;
        private final List<Integer> otherRightFields;

        JoinUsingAnalysis(List<Integer> leftJoinFields, List<Integer> rightJoinFields, List<Integer> otherLeftFields, List<Integer> otherRightFields) {
            this.leftJoinFields = ImmutableList.copyOf(leftJoinFields);
            this.rightJoinFields = ImmutableList.copyOf(rightJoinFields);
            this.otherLeftFields = ImmutableList.copyOf(otherLeftFields);
            this.otherRightFields = ImmutableList.copyOf(otherRightFields);
            Preconditions.checkArgument((leftJoinFields.size() == rightJoinFields.size() ? 1 : 0) != 0, (Object)"Expected join fields for left and right to have the same size");
        }

        public List<Integer> getLeftJoinFields() {
            return this.leftJoinFields;
        }

        public List<Integer> getRightJoinFields() {
            return this.rightJoinFields;
        }

        public List<Integer> getOtherLeftFields() {
            return this.otherLeftFields;
        }

        public List<Integer> getOtherRightFields() {
            return this.otherRightFields;
        }
    }

    @Immutable
    public static final class Insert {
        private final TableHandle target;
        private final List<ColumnHandle> columns;
        private final Optional<NewTableLayout> newTableLayout;

        public Insert(TableHandle target, List<ColumnHandle> columns, Optional<NewTableLayout> newTableLayout) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
            this.newTableLayout = Objects.requireNonNull(newTableLayout, "newTableLayout is null");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }

        public Optional<NewTableLayout> getNewTableLayout() {
            return this.newTableLayout;
        }
    }

    @Immutable
    public static final class Create {
        private final Optional<QualifiedObjectName> destination;
        private final Optional<ConnectorTableMetadata> metadata;
        private final Optional<NewTableLayout> layout;
        private final boolean createTableAsSelectWithData;
        private final boolean createTableAsSelectNoOp;

        public Create(Optional<QualifiedObjectName> destination, Optional<ConnectorTableMetadata> metadata, Optional<NewTableLayout> layout, boolean createTableAsSelectWithData, boolean createTableAsSelectNoOp) {
            this.destination = Objects.requireNonNull(destination, "destination is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
            this.createTableAsSelectWithData = createTableAsSelectWithData;
            this.createTableAsSelectNoOp = createTableAsSelectNoOp;
        }

        public Optional<QualifiedObjectName> getDestination() {
            return this.destination;
        }

        public Optional<ConnectorTableMetadata> getMetadata() {
            return this.metadata;
        }

        public Optional<NewTableLayout> getLayout() {
            return this.layout;
        }

        public boolean isCreateTableAsSelectWithData() {
            return this.createTableAsSelectWithData;
        }

        public boolean isCreateTableAsSelectNoOp() {
            return this.createTableAsSelectNoOp;
        }
    }

    @Immutable
    public static final class SelectExpression {
        private final Expression expression;
        private final Optional<List<Expression>> unfoldedExpressions;

        public SelectExpression(Expression expression, Optional<List<Expression>> unfoldedExpressions) {
            this.expression = Objects.requireNonNull(expression, "expression is null");
            this.unfoldedExpressions = Objects.requireNonNull(unfoldedExpressions);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Optional<List<Expression>> getUnfoldedExpressions() {
            return this.unfoldedExpressions;
        }
    }
}

