/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.MoreObjects;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import java.util.Objects;
import java.util.Optional;

public class RelationId {
    private final Optional<NodeRef<Node>> sourceNode;

    public static RelationId of(Node sourceNode) {
        return new RelationId(Optional.of(NodeRef.of((Node)sourceNode)));
    }

    public static RelationId anonymous() {
        return new RelationId(Optional.empty());
    }

    private RelationId(Optional<NodeRef<Node>> sourceNode) {
        this.sourceNode = sourceNode;
    }

    public boolean isAnonymous() {
        return !this.sourceNode.isPresent();
    }

    public Optional<Node> getSourceNode() {
        return this.sourceNode.map(NodeRef::getNode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationId that = (RelationId)o;
        return this.sourceNode.isPresent() && that.sourceNode.isPresent() && this.sourceNode.equals(that.sourceNode);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode);
    }

    public String toString() {
        if (this.isAnonymous()) {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)"anonymous").addValue((Object)String.format("x%08x", System.identityHashCode(this))).toString();
        }
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.sourceNode.get().getClass().getSimpleName()).addValue((Object)String.format("x%08x", System.identityHashCode(this.sourceNode.get()))).toString();
    }
}

