/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.expression.Constant;
import io.prestosql.spi.expression.FieldDereference;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorExpressionTranslator {
    private ConnectorExpressionTranslator() {
    }

    public static Expression translate(ConnectorExpression expression, Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
        return new ConnectorToSqlExpressionTranslator(variableMappings, literalEncoder).translate(expression);
    }

    public static Optional<ConnectorExpression> translate(Session session, Expression expression, TypeAnalyzer types, TypeProvider inputTypes) {
        return (Optional)new SqlToConnectorExpressionTranslator(types.getTypes(session, inputTypes, expression)).process((Node)expression);
    }

    static class SqlToConnectorExpressionTranslator
    extends AstVisitor<Optional<ConnectorExpression>, Void> {
        private final Map<NodeRef<Expression>, Type> types;

        public SqlToConnectorExpressionTranslator(Map<NodeRef<Expression>, Type> types) {
            this.types = Objects.requireNonNull(types, "types is null");
        }

        protected Optional<ConnectorExpression> visitSymbolReference(SymbolReference node, Void context) {
            return Optional.of(new Variable(node.getName(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitStringLiteral(StringLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getSlice(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDecimalLiteral(DecimalLiteral node, Void context) {
            return Optional.of(new Constant(Decimals.parse((String)node.getValue()).getObject(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitCharLiteral(CharLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getSlice(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitLongLiteral(LongLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitNullLiteral(NullLiteral node, Void context) {
            return Optional.of(new Constant(null, this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDereferenceExpression(DereferenceExpression node, Void context) {
            Optional translatedBase = (Optional)this.process((Node)node.getBase());
            if (!translatedBase.isPresent()) {
                return Optional.empty();
            }
            RowType rowType = (RowType)this.typeOf(node.getBase());
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            return Optional.of(new FieldDereference(this.typeOf((Expression)node), (ConnectorExpression)translatedBase.get(), index));
        }

        protected Optional<ConnectorExpression> visitExpression(Expression node, Void context) {
            return Optional.empty();
        }

        private Type typeOf(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }
    }

    private static class ConnectorToSqlExpressionTranslator {
        private final Map<String, Symbol> variableMappings;
        private final LiteralEncoder literalEncoder;

        public ConnectorToSqlExpressionTranslator(Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
            this.variableMappings = Objects.requireNonNull(variableMappings, "variableMappings is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
        }

        public Expression translate(ConnectorExpression expression) {
            if (expression instanceof Variable) {
                return this.variableMappings.get(((Variable)expression).getName()).toSymbolReference();
            }
            if (expression instanceof Constant) {
                return this.literalEncoder.toExpression(((Constant)expression).getValue(), expression.getType());
            }
            if (expression instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)expression;
                RowType type = (RowType)dereference.getTarget().getType();
                String name = (String)((RowType.Field)type.getFields().get(dereference.getField())).getName().get();
                return new DereferenceExpression(this.translate(dereference.getTarget()), new Identifier(name));
            }
            throw new UnsupportedOperationException("Expression type not supported: " + expression.getClass().getName());
        }
    }
}

