/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneApplyColumns
extends ProjectOffPushDownRule<ApplyNode> {
    public PruneApplyColumns() {
        super(Patterns.applyNode());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, ApplyNode applyNode, Set<Symbol> referencedOutputs) {
        boolean pruned;
        if (Sets.intersection(applyNode.getSubqueryAssignments().getSymbols(), referencedOutputs).isEmpty()) {
            return Optional.of(applyNode.getInput());
        }
        ImmutableSet.Builder requiredAssignmentsSymbols = ImmutableSet.builder();
        Assignments.Builder newSubqueryAssignments = Assignments.builder();
        for (Map.Entry<Symbol, Expression> entry : applyNode.getSubqueryAssignments().entrySet()) {
            if (!referencedOutputs.contains(entry.getKey())) continue;
            requiredAssignmentsSymbols.addAll(SymbolsExtractor.extractUnique(entry.getValue()));
            newSubqueryAssignments.put(entry);
        }
        Optional<PlanNode> newSubquery = Util.restrictOutputs(context.getIdAllocator(), applyNode.getSubquery(), (Set<Symbol>)requiredAssignmentsSymbols.build());
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(newSubquery.orElse(applyNode.getSubquery()), context.getLookup());
        List newCorrelation = (List)applyNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        ImmutableSet requiredInputSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll((Iterable)newCorrelation).addAll((Iterable)requiredAssignmentsSymbols.build()).build();
        Optional<PlanNode> newInput = Util.restrictOutputs(context.getIdAllocator(), applyNode.getInput(), (Set<Symbol>)requiredInputSymbols);
        boolean bl = pruned = newSubquery.isPresent() || newInput.isPresent() || newSubqueryAssignments.build().size() < applyNode.getSubqueryAssignments().size() || newCorrelation.size() < applyNode.getCorrelation().size();
        if (pruned) {
            return Optional.of(new ApplyNode(applyNode.getId(), newInput.orElse(applyNode.getInput()), newSubquery.orElse(applyNode.getSubquery()), newSubqueryAssignments.build(), newCorrelation, applyNode.getOriginSubquery()));
        }
        return Optional.empty();
    }
}

