/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneSemiJoinColumns
extends ProjectOffPushDownRule<SemiJoinNode> {
    public PruneSemiJoinColumns() {
        super(Patterns.semiJoin());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, SemiJoinNode semiJoinNode, Set<Symbol> referencedOutputs) {
        if (!referencedOutputs.contains(semiJoinNode.getSemiJoinOutput())) {
            return Optional.of(semiJoinNode.getSource());
        }
        Set requiredSourceInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(symbol -> !symbol.equals(semiJoinNode.getSemiJoinOutput())), Stream.of(semiJoinNode.getSourceJoinSymbol()), semiJoinNode.getSourceHashSymbol().map(Stream::of).orElse(Stream.empty())}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictOutputs(context.getIdAllocator(), semiJoinNode.getSource(), requiredSourceInputs).map(newSource -> semiJoinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)newSource, (Object)semiJoinNode.getFilteringSource())));
    }
}

