/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.IndexHandle;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IndexSourceNode
extends PlanNode {
    private final IndexHandle indexHandle;
    private final TableHandle tableHandle;
    private final Set<Symbol> lookupSymbols;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> currentConstraint;

    @JsonCreator
    public IndexSourceNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="indexHandle") IndexHandle indexHandle, @JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="lookupSymbols") Set<Symbol> lookupSymbols, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="currentConstraint") TupleDomain<ColumnHandle> currentConstraint) {
        super(id);
        this.indexHandle = Objects.requireNonNull(indexHandle, "indexHandle is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.lookupSymbols = ImmutableSet.copyOf((Collection)Objects.requireNonNull(lookupSymbols, "lookupSymbols is null"));
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputSymbols, "outputSymbols is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "effectiveTupleDomain is null");
        Preconditions.checkArgument((!lookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"lookupSymbols is empty");
        Preconditions.checkArgument((!outputSymbols.isEmpty() ? 1 : 0) != 0, (Object)"outputSymbols is empty");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(lookupSymbols), (Object)"Assignments do not include all lookup symbols");
        Preconditions.checkArgument((boolean)outputSymbols.containsAll(lookupSymbols), (Object)"Lookup symbols need to be part of the output symbols");
    }

    @JsonProperty
    public IndexHandle getIndexHandle() {
        return this.indexHandle;
    }

    @JsonProperty
    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Set<Symbol> getLookupSymbols() {
        return this.lookupSymbols;
    }

    @Override
    @JsonProperty
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        return this.currentConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitIndexSource(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

