/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import java.util.List;
import java.util.Objects;

public final class CallExpression
extends RowExpression {
    private final ResolvedFunction resolvedFunction;
    private final Type returnType;
    private final List<RowExpression> arguments;

    public CallExpression(ResolvedFunction resolvedFunction, Type returnType, List<RowExpression> arguments) {
        Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
        Objects.requireNonNull(arguments, "arguments is null");
        Objects.requireNonNull(returnType, "returnType is null");
        this.resolvedFunction = resolvedFunction;
        this.returnType = returnType;
        this.arguments = ImmutableList.copyOf(arguments);
    }

    public ResolvedFunction getResolvedFunction() {
        return this.resolvedFunction;
    }

    @Override
    public Type getType() {
        return this.returnType;
    }

    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return this.resolvedFunction.getSignature().getName() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        return Objects.equals(this.resolvedFunction, that.resolvedFunction) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resolvedFunction, this.returnType, this.arguments);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCall(this, context);
    }
}

