/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import java.util.List;

public class CharParametricType
implements ParametricType {
    public static final CharParametricType CHAR = new CharParametricType();

    public String getName() {
        return "char";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return CharType.createCharType((long)1L);
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected at most one parameter for CHAR");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("CHAR length must be a number");
        }
        return CharType.createCharType((long)parameter.getLongLiteral());
    }
}

