/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Property;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.TableElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTable
extends Statement {
    private final QualifiedName name;
    private final List<TableElement> elements;
    private final boolean notExists;
    private final List<Property> properties;
    private final Optional<String> comment;

    public CreateTable(QualifiedName name, List<TableElement> elements, boolean notExists, List<Property> properties, Optional<String> comment) {
        this(Optional.empty(), name, elements, notExists, properties, comment);
    }

    public CreateTable(NodeLocation location, QualifiedName name, List<TableElement> elements, boolean notExists, List<Property> properties, Optional<String> comment) {
        this(Optional.of(location), name, elements, notExists, properties, comment);
    }

    private CreateTable(Optional<NodeLocation> location, QualifiedName name, List<TableElement> elements, boolean notExists, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "table is null");
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements is null"));
        this.notExists = notExists;
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<TableElement> getElements() {
        return this.elements;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.elements).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.elements, this.notExists, this.properties, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTable o = (CreateTable)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.elements, o.elements) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("elements", this.elements).add("notExists", this.notExists).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

