/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression trueValue;
    private final Optional<Expression> falseValue;

    public IfExpression(Expression condition, Expression trueValue, Expression falseValue) {
        this(Optional.empty(), condition, trueValue, falseValue);
    }

    public IfExpression(NodeLocation location, Expression condition, Expression trueValue, Expression falseValue) {
        this(Optional.of(location), condition, trueValue, falseValue);
    }

    private IfExpression(Optional<NodeLocation> location, Expression condition, Expression trueValue, Expression falseValue) {
        super(location);
        this.condition = Objects.requireNonNull(condition, "condition is null");
        this.trueValue = Objects.requireNonNull(trueValue, "trueValue is null");
        this.falseValue = Optional.ofNullable(falseValue);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueValue() {
        return this.trueValue;
    }

    public Optional<Expression> getFalseValue() {
        return this.falseValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIfExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.falseValue.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.add((Object)this.condition).add((Object)this.trueValue).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IfExpression o = (IfExpression)obj;
        return Objects.equals(this.condition, o.condition) && Objects.equals(this.trueValue, o.trueValue) && Objects.equals(this.falseValue, o.falseValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.trueValue, this.falseValue);
    }
}

