/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SearchedCaseExpression
extends Expression {
    private final List<WhenClause> whenClauses;
    private final Optional<Expression> defaultValue;

    public SearchedCaseExpression(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        this(Optional.empty(), whenClauses, defaultValue);
    }

    public SearchedCaseExpression(NodeLocation location, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        this(Optional.of(location), whenClauses, defaultValue);
    }

    private SearchedCaseExpression(Optional<NodeLocation> location, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        super(location);
        Objects.requireNonNull(whenClauses, "whenClauses is null");
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.whenClauses = ImmutableList.copyOf(whenClauses);
        this.defaultValue = defaultValue;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSearchedCaseExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.whenClauses);
        this.defaultValue.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchedCaseExpression that = (SearchedCaseExpression)o;
        return Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.whenClauses, this.defaultValue);
    }
}

