/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.avro;

import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.RowDecoderFactory;
import io.prestosql.decoder.avro.AvroRowDecoder;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;

public class AvroRowDecoderFactory
implements RowDecoderFactory {
    @Override
    public RowDecoder create(Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        String dataSchema = Objects.requireNonNull(decoderParams.get("dataSchema"), "dataSchema cannot be null");
        Schema parsedSchema = new Schema.Parser().parse(dataSchema);
        return new AvroRowDecoder((DatumReader<GenericRecord>)new GenericDatumReader(parsedSchema), columns);
    }
}

