/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.impl;

import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.TopicType;

public final class AutoTopicCreationOverrideImpl
implements AutoTopicCreationOverride {
    private boolean allowAutoTopicCreation;
    private String topicType;
    private Integer defaultNumPartitions;

    public static boolean isValidOverride(AutoTopicCreationOverride override) {
        if (override == null) {
            return false;
        }
        if (override.isAllowAutoTopicCreation()) {
            if (!TopicType.isValidTopicType(override.getTopicType())) {
                return false;
            }
            if (TopicType.PARTITIONED.toString().equals(override.getTopicType())) {
                if (override.getDefaultNumPartitions() == null) {
                    return false;
                }
                if (override.getDefaultNumPartitions() <= 0) {
                    return false;
                }
            } else if (TopicType.NON_PARTITIONED.toString().equals(override.getTopicType()) && override.getDefaultNumPartitions() != null) {
                return false;
            }
        }
        return true;
    }

    public static AutoTopicCreationOverrideImplBuilder builder() {
        return new AutoTopicCreationOverrideImplBuilder();
    }

    @Override
    public boolean isAllowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    @Override
    public String getTopicType() {
        return this.topicType;
    }

    @Override
    public Integer getDefaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    public void setAllowAutoTopicCreation(boolean allowAutoTopicCreation) {
        this.allowAutoTopicCreation = allowAutoTopicCreation;
    }

    public void setTopicType(String topicType) {
        this.topicType = topicType;
    }

    public void setDefaultNumPartitions(Integer defaultNumPartitions) {
        this.defaultNumPartitions = defaultNumPartitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoTopicCreationOverrideImpl)) {
            return false;
        }
        AutoTopicCreationOverrideImpl other = (AutoTopicCreationOverrideImpl)o;
        if (this.isAllowAutoTopicCreation() != other.isAllowAutoTopicCreation()) {
            return false;
        }
        Integer this$defaultNumPartitions = this.getDefaultNumPartitions();
        Integer other$defaultNumPartitions = other.getDefaultNumPartitions();
        if (this$defaultNumPartitions == null ? other$defaultNumPartitions != null : !((Object)this$defaultNumPartitions).equals(other$defaultNumPartitions)) {
            return false;
        }
        String this$topicType = this.getTopicType();
        String other$topicType = other.getTopicType();
        return !(this$topicType == null ? other$topicType != null : !this$topicType.equals(other$topicType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowAutoTopicCreation() ? 79 : 97);
        Integer $defaultNumPartitions = this.getDefaultNumPartitions();
        result = result * 59 + ($defaultNumPartitions == null ? 43 : ((Object)$defaultNumPartitions).hashCode());
        String $topicType = this.getTopicType();
        result = result * 59 + ($topicType == null ? 43 : $topicType.hashCode());
        return result;
    }

    public String toString() {
        return "AutoTopicCreationOverrideImpl(allowAutoTopicCreation=" + this.isAllowAutoTopicCreation() + ", topicType=" + this.getTopicType() + ", defaultNumPartitions=" + this.getDefaultNumPartitions() + ")";
    }

    public AutoTopicCreationOverrideImpl(boolean allowAutoTopicCreation, String topicType, Integer defaultNumPartitions) {
        this.allowAutoTopicCreation = allowAutoTopicCreation;
        this.topicType = topicType;
        this.defaultNumPartitions = defaultNumPartitions;
    }

    public AutoTopicCreationOverrideImpl() {
    }

    public static class AutoTopicCreationOverrideImplBuilder
    implements AutoTopicCreationOverride.Builder {
        private boolean allowAutoTopicCreation;
        private String topicType;
        private Integer defaultNumPartitions;

        @Override
        public AutoTopicCreationOverrideImplBuilder allowAutoTopicCreation(boolean allowAutoTopicCreation) {
            this.allowAutoTopicCreation = allowAutoTopicCreation;
            return this;
        }

        @Override
        public AutoTopicCreationOverrideImplBuilder topicType(String topicType) {
            this.topicType = topicType;
            return this;
        }

        @Override
        public AutoTopicCreationOverrideImplBuilder defaultNumPartitions(Integer defaultNumPartitions) {
            this.defaultNumPartitions = defaultNumPartitions;
            return this;
        }

        @Override
        public AutoTopicCreationOverrideImpl build() {
            return new AutoTopicCreationOverrideImpl(this.allowAutoTopicCreation, this.topicType, this.defaultNumPartitions);
        }
    }
}

