/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.AsyncExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.function.AsyncRunnable;
import net.jodah.failsafe.function.AsyncSupplier;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.CheckedSupplier;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.function.ContextualSupplier;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

final class Functions {
    private static final CompletableFuture<ExecutionResult> NULL_FUTURE = CompletableFuture.completedFuture(null);

    Functions() {
    }

    static <T> SettableSupplier<CompletableFuture<T>> settableSupplierOf(final Supplier<CompletableFuture<T>> supplier) {
        return new SettableSupplier<CompletableFuture<T>>(){
            volatile boolean called;
            volatile CompletableFuture<T> value;

            @Override
            public CompletableFuture<T> get() {
                if (!this.called && this.value != null) {
                    this.called = true;
                    return this.value;
                }
                return (CompletableFuture)supplier.get();
            }

            @Override
            public void set(CompletableFuture<T> value) {
                this.called = false;
                this.value = value;
            }
        };
    }

    static Supplier<CompletableFuture<ExecutionResult>> makeAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<Object> future) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> Functions.lambda$null$1((Supplier)supplier, promise);
            try {
                future.inject(scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS));
            }
            catch (Exception e) {
                promise.completeExceptionally(e);
            }
            return promise;
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> promiseOf(CheckedSupplier<T> supplier, AbstractExecution execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            ExecutionResult result;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get());
            }
            catch (Throwable e) {
                result = ExecutionResult.failure(e);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static Supplier<CompletableFuture<ExecutionResult>> promiseOf(CheckedRunnable runnable, AbstractExecution execution) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            ExecutionResult result;
            try {
                execution.preExecute();
                runnable.run();
                result = ExecutionResult.NONE;
            }
            catch (Throwable e) {
                result = ExecutionResult.failure(e);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> promiseOf(ContextualSupplier<T> supplier, AbstractExecution execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            ExecutionResult result;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get(execution));
            }
            catch (Throwable e) {
                result = ExecutionResult.failure(e);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static Supplier<CompletableFuture<ExecutionResult>> promiseOf(ContextualRunnable runnable, AbstractExecution execution) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            ExecutionResult result;
            try {
                execution.preExecute();
                runnable.run(execution);
                result = ExecutionResult.NONE;
            }
            catch (Throwable e) {
                result = ExecutionResult.failure(e);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> asyncOfExecution(final AsyncSupplier<T> supplier, final AsyncExecution execution) {
        Assert.notNull(supplier, "supplier");
        return new Supplier<CompletableFuture<ExecutionResult>>(){

            @Override
            public synchronized CompletableFuture<ExecutionResult> get() {
                try {
                    execution.preExecute();
                    supplier.get(execution);
                }
                catch (Throwable e) {
                    execution.completeOrHandle(null, e);
                }
                return NULL_FUTURE;
            }
        };
    }

    static Supplier<CompletableFuture<ExecutionResult>> asyncOfExecution(final AsyncRunnable runnable, final AsyncExecution execution) {
        Assert.notNull(runnable, "runnable");
        return new Supplier<CompletableFuture<ExecutionResult>>(){

            @Override
            public synchronized CompletableFuture<ExecutionResult> get() {
                try {
                    execution.preExecute();
                    runnable.run(execution);
                }
                catch (Throwable e) {
                    execution.completeOrHandle(null, e);
                }
                return NULL_FUTURE;
            }
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> promiseOfStage(CheckedSupplier<? extends CompletionStage<? extends T>> supplier, AbstractExecution execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
            try {
                execution.preExecute();
                ((CompletionStage)supplier.get()).whenComplete((innerResult, failure) -> {
                    ExecutionResult result;
                    if (failure != null) {
                        if (failure instanceof CompletionException) {
                            failure = failure.getCause();
                        }
                        result = ExecutionResult.failure(failure);
                    } else {
                        result = ExecutionResult.success(innerResult);
                    }
                    execution.record(result);
                    promise.complete(result);
                });
            }
            catch (Throwable e) {
                ExecutionResult result = ExecutionResult.failure(e);
                execution.record(result);
                promise.complete(result);
            }
            return promise;
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> promiseOfStage(ContextualSupplier<? extends CompletionStage<? extends T>> supplier, AbstractExecution execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
            try {
                execution.preExecute();
                ((CompletionStage)supplier.get(execution)).whenComplete((innerResult, failure) -> {
                    ExecutionResult result;
                    if (failure != null) {
                        if (failure instanceof CompletionException) {
                            failure = failure.getCause();
                        }
                        result = ExecutionResult.failure(failure);
                    } else {
                        result = ExecutionResult.success(innerResult);
                    }
                    execution.record(result);
                    promise.complete(result);
                });
            }
            catch (Throwable e) {
                ExecutionResult result = ExecutionResult.failure(e);
                execution.record(result);
                promise.complete(result);
            }
            return promise;
        };
    }

    static <T> Supplier<CompletableFuture<ExecutionResult>> asyncOfFutureExecution(final AsyncSupplier<? extends CompletionStage<? extends T>> supplier, final AsyncExecution execution) {
        Assert.notNull(supplier, "supplier");
        return new Supplier<CompletableFuture<ExecutionResult>>(){
            Semaphore asyncFutureLock = new Semaphore(1);

            @Override
            public CompletableFuture<ExecutionResult> get() {
                try {
                    execution.preExecute();
                    this.asyncFutureLock.acquire();
                    ((CompletionStage)supplier.get(execution)).whenComplete((innerResult, failure) -> {
                        try {
                            if (failure != null) {
                                execution.completeOrHandle(innerResult, failure instanceof CompletionException ? failure.getCause() : failure);
                            }
                        }
                        finally {
                            this.asyncFutureLock.release();
                        }
                    });
                }
                catch (Throwable e) {
                    try {
                        execution.completeOrHandle(null, e);
                    }
                    finally {
                        this.asyncFutureLock.release();
                    }
                }
                return NULL_FUTURE;
            }
        };
    }

    static <T> Supplier<ExecutionResult> resultSupplierOf(CheckedSupplier<T> supplier, AbstractExecution execution) {
        return () -> {
            ExecutionResult result = null;
            try {
                result = ExecutionResult.success(supplier.get());
            }
            catch (Throwable t) {
                result = ExecutionResult.failure(t);
            }
            finally {
                execution.record(result);
            }
            return result;
        };
    }

    static <T> CheckedSupplier<T> supplierOf(CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            runnable.run();
            return null;
        };
    }

    static <T> CheckedSupplier<T> supplierOf(ContextualSupplier<T> supplier, ExecutionContext context) {
        Assert.notNull(supplier, "supplier");
        return () -> supplier.get(context);
    }

    static <T> CheckedSupplier<T> supplierOf(ContextualRunnable runnable, ExecutionContext context) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            runnable.run(context);
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> fnOf(CheckedSupplier<R> supplier) {
        return t -> supplier.get();
    }

    static <T, R> CheckedFunction<T, R> fnOf(CheckedConsumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> fnOf(CheckedRunnable runnable) {
        return t -> {
            runnable.run();
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> fnOf(R result) {
        return t -> result;
    }

    private static /* synthetic */ Object lambda$null$1(Supplier supplier, CompletableFuture promise) throws Exception {
        return ((CompletableFuture)supplier.get()).handle((result, error) -> {
            if (result != null) {
                promise.complete(result);
            } else {
                promise.completeExceptionally((Throwable)error);
            }
            return result;
        });
    }

    static interface SettableSupplier<T>
    extends Supplier<T> {
        public void set(T var1);
    }
}

