/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantResources
extends BaseResources<TenantInfo> {
    private static final Logger log = LoggerFactory.getLogger(TenantResources.class);

    public TenantResources(MetadataStore store, int operationTimeoutSec) {
        super(store, TenantInfo.class, operationTimeoutSec);
    }

    public List<String> listTenants() throws MetadataStoreException {
        return this.getChildren("/admin/policies");
    }

    public CompletableFuture<List<String>> listTenantsAsync() {
        return this.getChildrenAsync("/admin/policies");
    }

    public CompletableFuture<Void> deleteTenantAsync(String tenantName) {
        return ((CompletableFuture)this.getChildrenAsync(TenantResources.joinPath("/admin/policies", tenantName)).thenCompose(clusters -> FutureUtil.waitForAll(clusters.stream().map(cluster -> this.getCache().delete(TenantResources.joinPath("/admin/policies", tenantName, cluster))).collect(Collectors.toList())))).thenCompose(__ -> this.deleteAsync(TenantResources.joinPath("/admin/policies", tenantName)));
    }

    public boolean tenantExists(String tenantName) throws MetadataStoreException {
        return this.exists(TenantResources.joinPath("/admin/policies", tenantName));
    }

    public Optional<TenantInfo> getTenant(String tenantName) throws MetadataStoreException {
        return this.get(TenantResources.joinPath("/admin/policies", tenantName));
    }

    public CompletableFuture<Optional<TenantInfo>> getTenantAsync(String tenantName) {
        return this.getAsync(TenantResources.joinPath("/admin/policies", tenantName));
    }

    public void createTenant(String tenantName, TenantInfo ti) throws MetadataStoreException {
        this.create(TenantResources.joinPath("/admin/policies", tenantName), ti);
    }

    public CompletableFuture<Void> createTenantAsync(String tenantName, TenantInfo ti) {
        return this.createAsync(TenantResources.joinPath("/admin/policies", tenantName), ti);
    }

    public CompletableFuture<Void> updateTenantAsync(String tenantName, Function<TenantInfo, TenantInfo> f) {
        return this.setAsync(TenantResources.joinPath("/admin/policies", tenantName), f);
    }

    public CompletableFuture<Boolean> tenantExistsAsync(String tenantName) {
        return this.getCache().exists(TenantResources.joinPath("/admin/policies", tenantName));
    }

    public List<String> getListOfNamespaces(String tenant) throws MetadataStoreException {
        ArrayList namespaces = Lists.newArrayList();
        for (String clusterOrNamespace : this.getChildren(TenantResources.joinPath("/admin/policies", tenant))) {
            List<String> children = this.getChildren(TenantResources.joinPath("/admin/policies", tenant, clusterOrNamespace));
            if (children == null || children.isEmpty()) {
                String namespace = NamespaceName.get((String)tenant, (String)clusterOrNamespace).toString();
                try {
                    if (!this.get(TenantResources.joinPath("/admin/policies", namespace)).isPresent()) continue;
                    namespaces.add(namespace);
                }
                catch (MetadataStoreException.ContentDeserializationException contentDeserializationException) {}
                continue;
            }
            children.forEach(ns -> namespaces.add(NamespaceName.get((String)tenant, (String)clusterOrNamespace, (String)ns).toString()));
        }
        return namespaces;
    }

    public CompletableFuture<List<String>> getActiveNamespaces(String tenant, String cluster) {
        return this.getChildrenAsync(TenantResources.joinPath("/admin/policies", tenant, cluster));
    }

    public CompletableFuture<Void> hasActiveNamespace(String tenant) {
        CompletableFuture<Void> activeNamespaceFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.getChildrenAsync(TenantResources.joinPath("/admin/policies", tenant)).thenAccept(clusterOrNamespaceList -> {
            if (clusterOrNamespaceList == null || clusterOrNamespaceList.isEmpty()) {
                activeNamespaceFuture.complete(null);
                return;
            }
            ArrayList activeNamespaceListFuture = Lists.newArrayList();
            clusterOrNamespaceList.forEach(clusterOrNamespace -> {
                CompletableFuture checkNs = new CompletableFuture();
                activeNamespaceListFuture.add(checkNs);
                this.getChildrenAsync(TenantResources.joinPath("/admin/policies", tenant, clusterOrNamespace)).whenComplete((children, ex) -> {
                    if (ex != null) {
                        checkNs.completeExceptionally((Throwable)ex);
                        return;
                    }
                    if (children != null && !children.isEmpty()) {
                        checkNs.completeExceptionally(new IllegalStateException("The tenant still has active namespaces"));
                        return;
                    }
                    String namespace = NamespaceName.get((String)tenant, (String)clusterOrNamespace).toString();
                    ((CompletableFuture)this.getAsync(TenantResources.joinPath("/admin/policies", namespace)).thenApply(data -> {
                        if (data.isPresent()) {
                            checkNs.completeExceptionally(new IllegalStateException("The tenant still has active namespaces"));
                        } else {
                            checkNs.complete(null);
                        }
                        return null;
                    })).exceptionally(ex2 -> {
                        if (ex2.getCause() instanceof MetadataStoreException.ContentDeserializationException) {
                            checkNs.complete(null);
                        } else {
                            checkNs.completeExceptionally((Throwable)ex2);
                        }
                        return null;
                    });
                });
                ((CompletableFuture)FutureUtil.waitForAll((List)activeNamespaceListFuture).thenAccept(r -> activeNamespaceFuture.complete(null))).exceptionally(ex -> {
                    activeNamespaceFuture.completeExceptionally(ex.getCause());
                    return null;
                });
            });
        })).exceptionally(ex -> {
            activeNamespaceFuture.completeExceptionally(ex.getCause());
            return null;
        });
        return activeNamespaceFuture;
    }
}

